/*
 * Decompiled with CFR 0.152.
 */
package imp;

import imp.ImpData;
import imp.ImpIbs;
import ints.IntIntMap;
import ints.IntList;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.stream.IntStream;
import main.CompHapSegment;

public final class ImpStates {
    private final int NIL = -103;
    private final ImpIbs ibsHaps;
    private final ImpData impData;
    private final int nClusters;
    private final int maxStates;
    private final IntIntMap hapToEnd;
    private final PriorityQueue<CompHapSegment> q;
    private final IntList[] compositeHapToHap;
    private final IntList[] compositeHapToEnd;
    private final int[] compHapToListIndex;
    private final int[] compHapToHap;
    private final int[] compHapToEnd;

    public ImpStates(ImpIbs impIbs) {
        this.ibsHaps = impIbs;
        this.impData = impIbs.impData();
        this.nClusters = impIbs.impData().nClusters();
        this.maxStates = this.impData.par().imp_states();
        this.hapToEnd = new IntIntMap(this.maxStates);
        this.q = new PriorityQueue(this.maxStates);
        this.compositeHapToHap = (IntList[])IntStream.range(0, this.maxStates).mapToObj(n -> new IntList()).toArray(IntList[]::new);
        this.compositeHapToEnd = (IntList[])IntStream.range(0, this.maxStates).mapToObj(n -> new IntList()).toArray(IntList[]::new);
        this.compHapToListIndex = new int[this.maxStates];
        this.compHapToHap = new int[this.maxStates];
        this.compHapToEnd = new int[this.maxStates];
    }

    public int maxStates() {
        return this.maxStates;
    }

    public int ibsStates(int n, int[][] nArray, boolean[][] blArray) {
        int n2;
        this.initializeFields();
        int n3 = this.ibsHaps.codedSteps().nSteps();
        for (n2 = 0; n2 < n3; ++n2) {
            int[] nArray2;
            for (int n4 : nArray2 = this.ibsHaps.ibsHaps(n, n2)) {
                this.updateFields(n4, n2);
            }
        }
        if (this.q.isEmpty()) {
            this.fillQWithRandomHaps(n);
        }
        n2 = this.copyData(n, nArray, blArray);
        return n2;
    }

    private void initializeFields() {
        this.hapToEnd.clear();
        int n = this.q.size();
        for (int i = 0; i < n; ++i) {
            this.compositeHapToHap[i].clear();
            this.compositeHapToEnd[i].clear();
        }
        this.q.clear();
    }

    private void updateFields(int n, int n2) {
        if (this.hapToEnd.get(n, -103) == -103) {
            this.updateHeadOfQ();
            if (this.q.size() == this.maxStates) {
                CompHapSegment compHapSegment = this.q.poll();
                int n3 = this.ibsHaps.codedSteps().stepStart(compHapSegment.ibsStep() + n2 >>> 1);
                this.hapToEnd.remove(compHapSegment.hap());
                this.compositeHapToHap[compHapSegment.compHapIndex()].add(n);
                this.compositeHapToEnd[compHapSegment.compHapIndex()].add(n3);
                compHapSegment.updateSegment(n, n3, n2);
                this.q.offer(compHapSegment);
            } else {
                int n4 = this.q.size();
                this.compositeHapToHap[n4].add(n);
                this.q.offer(new CompHapSegment(n, 0, n2, n4));
            }
        }
        this.hapToEnd.put(n, n2);
    }

    private void updateHeadOfQ() {
        CompHapSegment compHapSegment = this.q.peek();
        if (compHapSegment != null) {
            int n = this.hapToEnd.get(compHapSegment.hap(), -103);
            while (compHapSegment.ibsStep() != n) {
                compHapSegment = this.q.poll();
                compHapSegment.updateStep(n);
                this.q.offer(compHapSegment);
                compHapSegment = this.q.peek();
                n = this.hapToEnd.get(compHapSegment.hap(), -103);
            }
        }
    }

    private int copyData(int n, int[][] nArray, boolean[][] blArray) {
        int n2 = this.q.size();
        int n3 = this.impData.nRefHaps() + n;
        this.initializeCopy(n2);
        for (int i = 0; i < this.nClusters; ++i) {
            int n4 = this.impData.allele(i, n3);
            for (int j = 0; j < n2; ++j) {
                if (i == this.compHapToEnd[j]) {
                    int n5 = j;
                    this.compHapToListIndex[n5] = this.compHapToListIndex[n5] + 1;
                    this.compHapToHap[j] = this.compositeHapToHap[j].get(this.compHapToListIndex[j]);
                    this.compHapToEnd[j] = this.compositeHapToEnd[j].get(this.compHapToListIndex[j]);
                }
                nArray[i][j] = this.compHapToHap[j];
                blArray[i][j] = this.impData.allele(i, this.compHapToHap[j]) == n4;
            }
        }
        return n2;
    }

    private void initializeCopy(int n) {
        for (int i = 0; i < n; ++i) {
            this.compositeHapToEnd[i].add(this.nClusters);
            this.compHapToListIndex[i] = 0;
            this.compHapToHap[i] = this.compositeHapToHap[i].get(0);
            this.compHapToEnd[i] = this.compositeHapToEnd[i].get(0);
        }
    }

    private void fillQWithRandomHaps(int n) {
        assert (this.q.isEmpty());
        int n2 = this.impData.nRefHaps();
        int n3 = Math.min(n2, this.maxStates);
        Random random = new Random(n);
        for (int i = 0; i < n3; ++i) {
            int n4 = random.nextInt(n2);
            this.compositeHapToHap[i].add(n4);
            this.q.add(new CompHapSegment(n4, 0, this.nClusters, i));
        }
    }
}

