/*
 * Decompiled with CFR 0.152.
 */
package phase;

import blbutil.FloatArray;
import blbutil.MultiThreadUtils;
import blbutil.Utilities;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import main.Par;
import phase.FixedPhaseData;
import phase.HmmParamData;
import phase.LowFreqPhaseIbs;
import phase.ParamEstimates;
import phase.PbwtPhaseIbs;
import phase.PhaseBaum1;
import phase.PhaseData;
import phase.Stage2Baum;
import phase.Stage2Haps;
import vcf.GT;

public class PhaseLS {
    private static final Float MIN_PMISMATCH = Float.valueOf(1.0E-12f);

    private PhaseLS() {
    }

    public static void runStage1(PhaseData phaseData) {
        Par par = phaseData.fpd().par();
        int n = par.nthreads();
        int n2 = phaseData.fpd().targGT().nSamples();
        int n3 = par.burnin();
        PbwtPhaseIbs pbwtPhaseIbs = PhaseLS.pbwtPhaseIbs(phaseData);
        if (phaseData.it() == 0) {
            PhaseLS.initializeParameters(pbwtPhaseIbs);
        } else if (phaseData.it() < n3) {
            PhaseLS.resetPMismatchToDefault(phaseData);
            PhaseLS.updateParameters(pbwtPhaseIbs);
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        for (int i = 0; i < n; ++i) {
            executorService.submit(() -> {
                try {
                    PhaseBaum1 phaseBaum1 = new PhaseBaum1(pbwtPhaseIbs);
                    int n2 = atomicInteger.getAndIncrement();
                    while (n2 < n2) {
                        phaseBaum1.phase(n2);
                        n2 = atomicInteger.getAndIncrement();
                    }
                }
                catch (Throwable throwable) {
                    Utilities.exit(throwable);
                }
            });
        }
        MultiThreadUtils.shutdownExecService(executorService);
    }

    private static PbwtPhaseIbs pbwtPhaseIbs(PhaseData phaseData) {
        boolean bl = (phaseData.it() & 1) == 0;
        PbwtPhaseIbs pbwtPhaseIbs = new PbwtPhaseIbs(phaseData, phaseData.codedSteps(), bl);
        return pbwtPhaseIbs;
    }

    private static void initializeParameters(PbwtPhaseIbs pbwtPhaseIbs) {
        boolean bl;
        PhaseData phaseData = pbwtPhaseIbs.phaseData();
        Random random = new Random(phaseData.seed());
        ParamEstimates paramEstimates = new ParamEstimates();
        PhaseLS.getParamEst(pbwtPhaseIbs, paramEstimates, random);
        if (PhaseLS.isBigDecrease(phaseData, paramEstimates)) {
            PhaseLS.decreaseRecombIntensity(pbwtPhaseIbs, paramEstimates, random);
        } else if (PhaseLS.isBigIncrease(phaseData, paramEstimates)) {
            PhaseLS.increaseRecombIntensity(pbwtPhaseIbs, paramEstimates, random);
        }
        int n = 0;
        float f = paramEstimates.recombIntensity();
        boolean bl2 = bl = f == 0.0f;
        while (++n < 6 && !bl) {
            phaseData.updateRecombIntensity(paramEstimates.recombIntensity());
            PhaseLS.getParamEst(pbwtPhaseIbs, paramEstimates, random);
            f = paramEstimates.recombIntensity();
            if (f == 0.0f) {
                bl = true;
                continue;
            }
            boolean bl3 = paramEstimates.recombIntensity() < 0.9f * phaseData.recombIntensity();
            boolean bl4 = paramEstimates.recombIntensity() > 1.1111f * phaseData.recombIntensity();
            bl = !bl3 && !bl4;
        }
        PhaseLS.updateParams(phaseData, paramEstimates);
    }

    private static void updateParameters(PbwtPhaseIbs pbwtPhaseIbs) {
        PhaseData phaseData = pbwtPhaseIbs.phaseData();
        Random random = new Random(pbwtPhaseIbs.phaseData().seed());
        ParamEstimates paramEstimates = new ParamEstimates();
        PhaseLS.getParamEst(pbwtPhaseIbs, paramEstimates, random);
        PhaseLS.updateParams(phaseData, paramEstimates);
    }

    private static void updateParams(PhaseData phaseData, ParamEstimates paramEstimates) {
        float f = paramEstimates.pMismatch();
        float f2 = paramEstimates.recombIntensity();
        if (f > 0.0f) {
            phaseData.updatePMismatch(Math.max(f, MIN_PMISMATCH.floatValue()));
        }
        if (f2 > 0.0f) {
            phaseData.updateRecombIntensity(f2);
        }
    }

    private static void decreaseRecombIntensity(PbwtPhaseIbs pbwtPhaseIbs, ParamEstimates paramEstimates, Random random) {
        PhaseData phaseData = pbwtPhaseIbs.phaseData();
        while (PhaseLS.isBigDecrease(phaseData, paramEstimates)) {
            float f = Math.min(0.333f * phaseData.recombIntensity(), paramEstimates.recombIntensity());
            phaseData.updateRecombIntensity(f);
            PhaseLS.getParamEst(pbwtPhaseIbs, paramEstimates, random);
        }
    }

    private static void increaseRecombIntensity(PbwtPhaseIbs pbwtPhaseIbs, ParamEstimates paramEstimates, Random random) {
        PhaseData phaseData = pbwtPhaseIbs.phaseData();
        while (PhaseLS.isBigIncrease(phaseData, paramEstimates)) {
            float f = Math.max(3.0f * phaseData.recombIntensity(), paramEstimates.recombIntensity());
            phaseData.updateRecombIntensity(f);
            PhaseLS.getParamEst(pbwtPhaseIbs, paramEstimates, random);
        }
    }

    private static boolean isBigDecrease(PhaseData phaseData, ParamEstimates paramEstimates) {
        float f = paramEstimates.recombIntensity();
        return f > 0.0f && f < 0.8f * phaseData.recombIntensity();
    }

    private static boolean isBigIncrease(PhaseData phaseData, ParamEstimates paramEstimates) {
        float f = paramEstimates.recombIntensity();
        return f > 0.0f && f > 1.25f * phaseData.recombIntensity();
    }

    private static void resetPMismatchToDefault(PhaseData phaseData) {
        phaseData.updatePMismatch(Par.liStephensPMismatch(phaseData.fpd().nHaps()));
    }

    private static void getParamEst(PbwtPhaseIbs pbwtPhaseIbs, ParamEstimates paramEstimates, Random random) {
        paramEstimates.clear();
        PhaseData phaseData = pbwtPhaseIbs.phaseData();
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        int[] nArray = PhaseLS.samplesToAnalyze(phaseData, random);
        int n = Math.min(fixedPhaseData.par().nthreads(), nArray.length);
        float f = 0.05f;
        float f2 = PhaseLS.maxMismatchMaf(fixedPhaseData.stage1Maf(), f);
        double d = 20000.0 / (double)n;
        int n2 = 50;
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        for (int i = 0; i < n; ++i) {
            executorService.submit(() -> {
                try {
                    HmmParamData hmmParamData = new HmmParamData(pbwtPhaseIbs, f2);
                    int n2 = atomicInteger.getAndIncrement();
                    while ((hmmParamData.sumSwitchProbs() < d || n2 < n2) && n2 < nArray.length) {
                        hmmParamData.update(nArray[n2]);
                        n2 = atomicInteger.getAndIncrement();
                    }
                    hmmParamData.addEstimationData(paramEstimates);
                }
                catch (Throwable throwable) {
                    Utilities.exit(throwable);
                }
            });
        }
        MultiThreadUtils.shutdownExecService(executorService);
    }

    private static int[] samplesToAnalyze(PhaseData phaseData, Random random) {
        int n = 500;
        int n2 = phaseData.fpd().targGT().nSamples();
        int[] nArray = IntStream.range(0, n2).parallel().toArray();
        if (n2 <= n) {
            return nArray;
        }
        Utilities.shuffle(nArray, n, random);
        return Arrays.copyOf(nArray, n);
    }

    private static float maxMismatchMaf(FloatArray floatArray, float f) {
        int n2;
        if (f <= 0.0f || f >= 1.0f || !Float.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        double[] dArray = IntStream.range(0, floatArray.size()).parallel().mapToDouble(n -> floatArray.get(n)).sorted().toArray();
        int n3 = Arrays.binarySearch(dArray, (double)1.4E-45f);
        if (n3 < 0) {
            n3 = -n3 - 1;
        }
        return (float)((n2 = n3 + (int)Math.floor(f * (float)(dArray.length - n3))) == dArray.length ? (double)1.4E-45f : dArray[n2]);
    }

    public static GT runStage2(PhaseData phaseData) {
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        int n = fixedPhaseData.par().nthreads();
        int n2 = fixedPhaseData.targGT().nSamples();
        LowFreqPhaseIbs lowFreqPhaseIbs = new LowFreqPhaseIbs(phaseData);
        Stage2Haps stage2Haps = new Stage2Haps(phaseData);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        for (int i = 0; i < n; ++i) {
            executorService.submit(() -> {
                try {
                    Stage2Baum stage2Baum = new Stage2Baum(lowFreqPhaseIbs, stage2Haps);
                    int n2 = atomicInteger.getAndIncrement();
                    while (n2 < n2) {
                        stage2Baum.phase(n2);
                        n2 = atomicInteger.getAndIncrement();
                    }
                }
                catch (Throwable throwable) {
                    Utilities.exit(throwable);
                }
            });
        }
        MultiThreadUtils.shutdownExecService(executorService);
        return stage2Haps.stage2Haps();
    }
}

