/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.StringUtil;
import blbutil.Utilities;
import java.io.File;
import java.util.Arrays;
import vcf.BasicMarker;
import vcf.Marker;
import vcf.VcfHeader;

public final class VcfRecGTParser {
    private final VcfHeader vcfHeader;
    private final String vcfRec;
    private final Marker marker;
    private final int nSamples;
    private int character;
    private int currentSample;
    private int unfilteredSample;
    private int allele1;
    private int allele2;
    private boolean isPhased;

    public VcfRecGTParser(VcfHeader vcfHeader, String string) {
        if (vcfHeader.nSamples() == 0) {
            throw new IllegalArgumentException("nSamples==0");
        }
        this.vcfHeader = vcfHeader;
        this.vcfRec = string;
        this.marker = new BasicMarker(string);
        this.nSamples = vcfHeader.nSamples();
        this.unfilteredSample = -1;
        this.character = -1;
        this.currentSample = -1;
        this.skipFixedFields();
        this.nextSample();
    }

    private void skipFixedFields() {
        for (int i = 0; i < 8; ++i) {
            this.character = this.vcfRec.indexOf(9, this.character + 1);
        }
        if (!this.vcfRec.startsWith("GT:", this.character + 1) && !this.vcfRec.startsWith("GT\t", this.character + 1)) {
            throw new IllegalArgumentException("invalid VCF rec: " + this.vcfRec);
        }
        this.character = this.vcfRec.indexOf(9, this.character + 1);
    }

    public VcfHeader vcfHeader() {
        return this.vcfHeader;
    }

    public String vcfRecord() {
        return this.vcfRec;
    }

    public Marker marker() {
        return this.marker;
    }

    public int currentSample() {
        return this.currentSample;
    }

    public int allele1() {
        return this.allele1;
    }

    public int allele2() {
        return this.allele2;
    }

    public boolean isPhased() {
        return this.isPhased;
    }

    public Samples samples() {
        return this.vcfHeader.samples();
    }

    public int nSamples() {
        return this.nSamples;
    }

    public void nextSample() {
        ++this.currentSample;
        if (this.currentSample == this.nSamples) {
            throw new IndexOutOfBoundsException(String.valueOf(this.currentSample));
        }
        int n = this.vcfHeader.unfilteredSampleIndex(this.currentSample);
        while (++this.unfilteredSample < n) {
            if (this.character == -1) {
                this.throwFieldCountError();
            }
            this.character = this.vcfRec.indexOf(9, this.character + 1);
        }
        if (this.character == -1) {
            this.throwFieldCountError();
        }
        int n2 = VcfRecGTParser.end1(this.vcfRec, this.character + 1);
        int n3 = VcfRecGTParser.end2(this.vcfRec, n2 + 1);
        this.allele1 = VcfRecGTParser.allele(this.vcfRec, this.marker.nAlleles(), this.character + 1, n2);
        this.allele2 = VcfRecGTParser.allele(this.vcfRec, this.marker.nAlleles(), n2 + 1, n3);
        this.isPhased = this.vcfRec.charAt(n2) != '/';
        this.character = this.vcfRec.indexOf(9, n3);
    }

    private static int end1(String string, int n) {
        int n2;
        if (n == string.length()) {
            VcfRecGTParser.throwGTFormatError(string, string.length());
        }
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c == '/' || c == '|') {
                return n2;
            }
            if (c != ':' && c != '\t') continue;
            VcfRecGTParser.throwGTFormatError(string, n2 + 1);
        }
        if (n2 == string.length()) {
            VcfRecGTParser.throwGTFormatError(string, string.length());
        }
        return n2;
    }

    private static int end2(String string, int n) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            char c = string.charAt(n2);
            if (c != ':' && c != '\t') continue;
            return n2;
        }
        return n2;
    }

    private static int allele(String string, int n, int n2, int n3) {
        int n4;
        if (n2 == n3) {
            String string2 = "Missing sample allele: " + string;
            throw new IllegalArgumentException(string2);
        }
        if (n2 + 1 == n3) {
            char c = string.charAt(n2);
            switch (c) {
                case '.': {
                    n4 = -1;
                    break;
                }
                case '0': {
                    n4 = 0;
                    break;
                }
                case '1': {
                    n4 = 1;
                    break;
                }
                case '2': {
                    n4 = 2;
                    break;
                }
                case '3': {
                    n4 = 3;
                    break;
                }
                case '4': {
                    n4 = 4;
                    break;
                }
                case '5': {
                    n4 = 5;
                    break;
                }
                case '6': {
                    n4 = 6;
                    break;
                }
                case '7': {
                    n4 = 7;
                    break;
                }
                case '8': {
                    n4 = 8;
                    break;
                }
                case '9': {
                    n4 = 9;
                    break;
                }
                default: {
                    String string3 = "invalid allele (" + c + "): " + string;
                    throw new IllegalArgumentException(string3);
                }
            }
        } else {
            n4 = Integer.parseInt(string.substring(n2, n3));
            if (n4 < 0) {
                String string4 = "invalid allele (" + n4 + "): " + Const.nl + string;
                throw new IllegalArgumentException(string4);
            }
        }
        if (n4 >= n) {
            String string5 = "invalid allele (" + n4 + "): " + Const.nl + string;
            throw new IllegalArgumentException(string5);
        }
        return n4;
    }

    private static void throwGTFormatError(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("ERROR: Missing one or both alleles for a genotype:");
        stringBuilder.append(Const.nl);
        stringBuilder.append(string.substring(0, n));
        stringBuilder.append(Const.nl);
        stringBuilder.append("Exiting Program");
        stringBuilder.append(Const.nl);
        Utilities.exit(stringBuilder.toString());
    }

    private void throwFieldCountError() {
        File file = this.vcfHeader.file();
        Object[] objectArray = StringUtil.getFields(this.vcfRec, '\t');
        StringBuilder stringBuilder = new StringBuilder(1000);
        stringBuilder.append("VCF header line has ");
        stringBuilder.append(this.vcfHeader.nHeaderFields());
        stringBuilder.append(" fields, but data line has ");
        stringBuilder.append(objectArray.length);
        stringBuilder.append(" fields");
        stringBuilder.append(Const.nl);
        stringBuilder.append("File source: ");
        stringBuilder.append(file != null ? file.toString() : "stdin");
        stringBuilder.append(Const.nl);
        stringBuilder.append(Arrays.toString(objectArray));
        stringBuilder.append(Const.nl);
        Utilities.exit(stringBuilder.toString());
    }
}

