% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IBDprob.R
\name{c.IBDprob}
\alias{c.IBDprob}
\title{Concatenate function for objects of class IBDprob}
\usage{
\method{c}{IBDprob}(...)
}
\arguments{
\item{...}{Objects of class \code{IBDprob}.}
}
\value{
An object of class \code{IBDprob} containing data for all
concatenated objects.
}
\description{
Concatenates objects of class \code{IBDprob}. All objects that are
concatenated should have the same population type and the same map. The
function is mainly meant for combining information for multiple crosses
with overlapping parents.
}
\examples{
## Compute IBD probabilties for AxB.
AB <- calcIBD(popType = "F4DH",
             markerFile = system.file("extdata/multipop", "AxB.txt",
                                  package = "statgenIBD"),
             mapFile = system.file("extdata/multipop", "mapfile.txt",
                                  package = "statgenIBD"))
## Compute IBD probabilties for Axc.
AC <- calcIBD(popType = "F4DH",
              markerFile = system.file("extdata/multipop", "AxC.txt",
                                      package = "statgenIBD"),
              mapFile = system.file("extdata/multipop", "mapfile.txt",
                                   package = "statgenIBD"))

## Combine results.
ABC <- c(AB, AC)

## Check summary.
summary(ABC)

}
