% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSTA.R
\name{report.STA}
\alias{report.STA}
\title{Report method for class STA}
\usage{
\method{report}{STA}(
  x,
  ...,
  trials = NULL,
  traits = NULL,
  descending = TRUE,
  outfile = NULL,
  what = c("fixed", "random")
)
}
\arguments{
\item{x}{An object of class STA.}

\item{...}{Further arguments passed to the report function.}

\item{trials}{A character vector indicating the trials to report. If
\code{trials = NULL}, all trials are reported.}

\item{traits}{A character vector indicating the traits to report. If
\code{traits = NULL}, all traits are reported.}

\item{descending}{Should the trait be ordered in descending order? Set to
\code{FALSE} if low values of the trait indicate better performance.}

\item{outfile}{A character string, the name and location of the output .pdf
and .tex file for the report. If \code{NULL}, a report with a default name
will be created in the current working directory. Trialname, traitname and
the type of model (genotype fixed or random) will be concatenated to the
name of the outputfile.\cr
Both knitr and pdflatex don't work well with spaces in file paths and these
are therefore disallowed. Relative paths are possible though.}

\item{what}{A character vector indicating whether the fitted model with
genotype as fixed or genotype as random factor should be reported. By
default all fitted models in the STA object are reported.}
}
\value{
A pdf report and the .tex file and figures folder that can be used
to recreate the report.
}
\description{
pdf reports will be created containing a summary of the results of the
fitted model(s). For all selected trails and traits a separate pdf file will
be generatd. Also a .tex file and a folder containing figures will be
created for each report to enable easy modifying of the report.
}
\details{
This function uses pdflatex to create a pdf report. For it to run correctly
an installation of LaTeX is requiered. Checking for this is done with
Sys.which("pdflatex").
}
\examples{
## Fit model using lme4.
myModel1 <- fitTD(TD = TDHeat05, design = "ibd", traits = "yield")
## Create a pdf report summarizing the results for the model with genotype
## as fixed factor.
\donttest{
report(myModel1, outfile = tempfile(fileext = ".pdf"), what = "fixed")
}

## Create two pdf report summarizing the results for the model with genotype
## as fixed factor and for the model with genotype as random factor. Order
## the results in ascending order.
\donttest{
report(myModel1, outfile = tempfile(fileext = ".pdf"), descending = FALSE)
}

}
\seealso{
Other STA: 
\code{\link{STAtoCross}()},
\code{\link{STAtoTD}()},
\code{\link{plot.STA}()},
\code{\link{summary.STA}()}
}
\concept{STA}
