% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/map_isd_stations.R
\name{map_isd_stations}
\alias{map_isd_stations}
\title{Display a maps of selected stations from the ISD dataset}
\usage{
map_isd_stations(stations)
}
\arguments{
\item{stations}{a data frame with station data, typically subset from the
data frame provided by the \code{get_isd_stations} function.}
}
\value{
a Leaflet map in the RStudio Viewer
}
\description{
Display a map of selected meteorological stations
from the NCEI Integrated Surface Dataset (ISD).
}
\examples{
\dontrun{
library(magrittr)

# Select stations using a bounding box and map the stations
get_isd_stations(lower_lat = 49.000,
                 upper_lat = 49.500,
                 lower_lon = -123.500,
                 upper_lon = -123.000) \%>\%
  map_isd_stations()
}
}

