% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distr2name.R, R/name2distr.R
\name{distr2name}
\alias{distr2name}
\alias{name2distr}
\title{Conversion between abbreviated distribution names and proper names}
\usage{
distr2name(x)

name2distr(x)
}
\arguments{
\item{x}{character. A vector of abbreviated distribution names 
or proper distribution names.}
}
\value{
A character vector of the same length as \code{x}. 
Elements of \code{x} that are not recognized are kept unchanged.
}
\description{
The function \code{distr2name} converts abbreviated 
distribution names to proper distribution names 
(e.g. \code{"norm"} becomes \code{"Gaussian"}). 

The function \code{name2distr} does the reciprocal operation.
}
\examples{
distr2name(c("norm", "dnorm", "rhyper", "ppois"))
name2distr(c("Cauchy", "Gaussian", "Generalized Extreme Value"))

}
