% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{size.test.prop2}
\alias{size.test.prop2}
\title{Sample size for a test of a 2-group proportion difference}
\usage{
size.test.prop2(alpha, pow, p1, p2, es)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p1}{planning value of proportion for group 1}

\item{p2}{planning value of proportion for group 2}

\item{es}{planning value of proportion difference}
}
\value{
Returns the required sample size per group
}
\description{
Computes the sample size in each group required to test a difference in
population proportions with desired power in a 2-group design. This
function requires planning values for both proportions. Set the proportion
planning values to .5 for a conservatively large sample size. The
planning value for the proportion difference could be set equal to
the difference of the two proportion planning values or it could be set
equal to a minimally interesting effect size.
}
\examples{
size.test.prop2(.05, .8, .2, .4, .2)

# Should return:
#      Sample size per group
# [1,]                    79


}
