% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mean2}
\alias{ci.mean2}
\title{Confidence interval for a 2-group mean difference}
\usage{
ci.mean2(alpha, m1, m2, sd1, sd2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean for group 1}

\item{m2}{estimated mean for group 2}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - estimated mean difference
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes equal variance and unequal variance confidence intervals for a
population 2-group mean difference using the estimated means, estimated
standard deviations, and sample sizes. Use the t.test function for raw data
input.
}
\examples{
ci.mean2(.05, 15.4, 10.3, 2.67, 2.15, 30, 20)

# Should return:
#                              Estimate       SE        t      df      
# Equal Variances Assumed:          5.1 1.602248 3.183029 48.0000 
# Equal Variances Not Assumed:      5.1 1.406801 3.625247 44.1137 
#                                          p       LL       UL
# Equal Variances Assumed:      0.0025578586 1.878465 8.321535
# Equal Variances Not Assumed:  0.0007438065 2.264986 7.935014


}
\references{
\insertRef{Snedecor1980}{statpsych}
}
