% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{pi.prop}
\alias{pi.prop}
\title{Prediction interval for an estimated proportion}
\usage{
pi.prop(alpha, prop, n0, n)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{prop}{estimated proportion from prior study}

\item{n0}{sample size used to estimate proportion in prior study}

\item{n}{planned sample size of future study}
}
\value{
Returns a prediction interval for an estimated proportion in a future
study
}
\description{
Computes approximate prediction interval for the estimated proportion
in a future study with a planned sample size of n. The prediction interval
uses a proportion estimate from a prior study that had a sample size of n0.
}
\examples{
pi.prop(.1, .225, 80, 120)

# Should return:
#         LL       UL
#  0.1390955 0.337095
 

}
