% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_anova.R
\name{expr_anova_bayes}
\alias{expr_anova_bayes}
\title{Expression containing Bayesian one-way ANOVA results}
\usage{
expr_anova_bayes(
  data,
  x,
  y,
  subject.id = NULL,
  paired = FALSE,
  bf.prior = 0.707,
  k = 2L,
  output = "expression",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{subject.id}{In case of repeated measures design (\code{paired = TRUE},
i.e.), this argument specifies the subject or repeated measures id. Note
that if this argument is \code{NULL} (which is the default), the function
assumes that the data has already been sorted by such an id by the user and
creates an internal identifier. So if your data is \strong{not} sorted and you
leave this argument unspecified, the results can be inaccurate.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\description{
Expression containing Bayesian one-way ANOVA results
}
\examples{
# setup
set.seed(123)
library(statsExpressions)

expr_anova_bayes(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem
)
}
