% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fsqca_sim.R
\name{fsqca_sim}
\alias{fsqca_sim}
\title{fsQCA Sufficiency Inclusion Score & Minimum Frequency Threshold Simulation}
\usage{
fsqca_sim(data, outcome, conditions, min.incl.cut,
max.incl.cut, min.n.cut, max.n.cut, reps, plot,
plot.legend, verbose, ...)
}
\arguments{
\item{data}{a data frame}

\item{outcome}{a character string or column index indicating the outcome variable}

\item{conditions}{optional character vector or vector of column indices indicating explanatory variables}

\item{min.incl.cut}{numeric lower bound for sampling of sufficiency inclusion scores}

\item{max.incl.cut}{numeric upper bound for sampling of sufficiency inclusion scores}

\item{min.n.cut}{numeric lower bound for minimum frequency thresholds}

\item{max.n.cut}{numeric upper bound for minimum frequency thresholds}

\item{reps}{number of sufficiency inclusion score pairs to be sampled}

\item{plot}{logical; if TRUE, returns a plot of solutions}

\item{plot.legend}{a character string indicating the type of legend to plot;
\code{solutions} indicates plot legend should contain actual unique solutions;
\code{ids} indicates plot should contain numeric identifiers for unique solutions;
\code{none} indicates plot should not contain a legend}

\item{verbose}{logical; if TRUE, prints additional execution information}

\item{...}{optional arguments passed to \code{eqmcc()}}
}
\value{
Returns a named list with the following components:

\item{\code{plot}}{(if \code{PLOT==TRUE}Plot of results across \code{incl.cut} and \code{n.cut} parameter values}
\item{\code{results}}{a data frame containing solutions produced for each set of sampled parameter values}
\item{\code{legend}}{a data frame containing QCA solutions and their unique identifiers }
}
\description{
\code{fsqca_sim} returns QCA results for a range of minimum frequency thresholds across
an arbitrarily large set of sufficiency inclusion scores
}
\examples{
# Load data
data(hh)

# Remove case indicator
hh<-hh[,-which(colnames(hh)=="Country")]

# Run function
fsqca_sim(data = hh, outcome = "success", reps=50, plot = TRUE)
}

