% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_cs.R
\name{NormalCS}
\alias{NormalCS}
\title{NormalCS Class}
\description{
NormalCS class is used to compute always-valid confidence sequence
for the standard normal process based on the STCP method.
}
\examples{
# Initialize two-sided standard normal confidence sequence
# optimized for the interval [10, 100]
normal_cs <- NormalCS$new(
  alternative = "two.sided",
  alpha = 0.05,
  n_upper = 100,
  n_lower = 10
  )
  
# Compute confidence interval at n = 20 when observed sample mean = 0.5
normal_cs$computeInterval(20, x_bar = 0.5)

# (Advanced) NormalCS supports general variance process.
# Both n_upper and n_lower can be general positive numbers.
normal_cs2 <- NormalCS$new(
  alternative = "two.sided",
  alpha = 0.05,
  n_upper = 100.5,
  n_lower = 10.5
  )
# Confidence interval at n = 20.5
normal_cs$computeInterval(20.5, x_bar = 0.5)

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NormalCS-new}{\code{NormalCS$new()}}
\item \href{#method-NormalCS-print}{\code{NormalCS$print()}}
\item \href{#method-NormalCS-getAlpha}{\code{NormalCS$getAlpha()}}
\item \href{#method-NormalCS-getWeights}{\code{NormalCS$getWeights()}}
\item \href{#method-NormalCS-getLambdas}{\code{NormalCS$getLambdas()}}
\item \href{#method-NormalCS-computeWidth}{\code{NormalCS$computeWidth()}}
\item \href{#method-NormalCS-computeInterval}{\code{NormalCS$computeInterval()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCS-new"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCS-new}{}}}
\subsection{Method \code{new()}}{
Create a new NormalCS object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCS$new(
  alternative = c("two.sided", "greater", "less"),
  alpha = 0.05,
  n_upper = 1000,
  n_lower = 1,
  weights = NULL,
  lambdas = NULL,
  k_max = 1000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{alternative}}{Alternative / post-change mean space
\itemize{
\item two.sided: Two-sided test / change detection
\item greater: Alternative /post-change mean is greater than null / pre-change one
\item less:  Alternative /post-change mean is less than null / pre-change one
}}

\item{\code{alpha}}{Upper bound on the type 1 error of the confidence sequence.}

\item{\code{n_upper}}{Upper bound of the target sample interval}

\item{\code{n_lower}}{Lower bound of the target sample interval}

\item{\code{weights}}{If not null, the input weights will be used to initialize the object
instead of \code{n_upper} and \code{n_lower}.}

\item{\code{lambdas}}{If not null, the input lambdas will be used to initialize the object.
instead of \code{n_upper} and \code{n_lower}.}

\item{\code{k_max}}{Positive integer to determine the maximum number of baselines.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{NormalCS} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCS-print"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCS-print}{}}}
\subsection{Method \code{print()}}{
Print summary of Stcp object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCS$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCS-getAlpha"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCS-getAlpha}{}}}
\subsection{Method \code{getAlpha()}}{
Return the upper bound on the type 1 error
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCS$getAlpha()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCS-getWeights"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCS-getWeights}{}}}
\subsection{Method \code{getWeights()}}{
Return weights of mixture of e-values / e-detectors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCS$getWeights()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCS-getLambdas"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCS-getLambdas}{}}}
\subsection{Method \code{getLambdas()}}{
Return lambda parameters of mixture of e-values / e-detectors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCS$getLambdas()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCS-computeWidth"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCS-computeWidth}{}}}
\subsection{Method \code{computeWidth()}}{
Compute the width of confidence interval at time n.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCS$computeWidth(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Positive time.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NormalCS-computeInterval"></a>}}
\if{latex}{\out{\hypertarget{method-NormalCS-computeInterval}{}}}
\subsection{Method \code{computeInterval()}}{
Compute a vector of two end points of confidence interval
at time n
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NormalCS$computeInterval(n, x_bar = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Positive time.}

\item{\code{x_bar}}{The center of the confidence interval.}
}
\if{html}{\out{</div>}}
}
}
}
