% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.r
\name{gaccounts}
\alias{gaccounts}
\title{Get the Steem account information within a period from SteemSQL
gaccounts means 'get account information'.}
\usage{
gaccounts(from = Sys.Date() - 7, to = Sys.Date(), select = c("name", "created", 
    "post_count", "last_post"), sql_con = NA, ylab = "Daily New Accounts", 
    if_plot = FALSE)
}
\arguments{
\item{from}{A Date object or character in '2017-10-24' format of the beginning of the period}

\item{to}{A Date object or character in '2017-10-24' format of the end of the period}

\item{select}{A character string vector of the column names}

\item{sql_con}{A SQL connection}

\item{ylab}{Label on the y-axis}

\item{if_plot}{A logic value of whether plot the time series}
}
\value{
A data frame of the account information with a figure
}
\description{
Get the Steem account information within a period from SteemSQL
gaccounts means 'get account information'.
}
\examples{
\dontrun{
gaccounts()
}
}
