% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.r
\name{objFun}
\alias{objFun}
\title{Objective function}
\usage{
objFun(x, y, lamda, w, beta, epsilon)
}
\arguments{
\item{x}{input matrix, of dimension nobs x nvars. Each row is an observation vector.}

\item{y}{binary response variable}

\item{lamda}{a tuning penalty parameter}

\item{w}{the weighting parameter for L1; then (1-w) is the weight for L0}

\item{beta}{coefficients}

\item{epsilon}{the continuity parameter}
}
\value{
the value of the objective function evaluated at the given points.
}
\description{
Objective (non-convex) function to minimize (objFun=-logL+ lamda*CL, CL= (1-w)L0 + wL1)
}
\examples{

set.seed(14)
beta    <- c(3, 2, -1.6, -4)
noise   <- 5
simData <- SimData(N=100, beta=beta, noise=noise, corr=FALSE)

x  <- as.matrix(simData[,-1][,1])
y  <- as.matrix(simData$y)
betapoints <- seq(-2,2,0.01)

lamda <- 1
w     <- 0.6
epsilon <- 0.1

out <- numeric(length(betapoints))
for(i in 1:length(betapoints)){
 out[i]<- objFun(x, y, lamda=lamda, w=w, beta=betapoints[i], epsilon=epsilon)
}
plot(betapoints, out, type="l", ylab="objFun")

}

