% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population_dispersal-functions.R
\name{fast_dispersal}
\alias{fast_dispersal}
\title{Fast diffusion-based dispersal}
\usage{
fast_dispersal(
  dispersal_kernel = exponential_dispersal_kernel(distance_decay = 0.1),
  dispersal_proportion = set_proportion_dispersing()
)
}
\arguments{
\item{dispersal_kernel}{a single built-in or user-defined distance dispersal
kernel function.}

\item{dispersal_proportion}{a built-in or custom function defining the proportions
of individuals that can disperse in each life stage.}
}
\description{
The fast_dispersal function uses kernel-based dispersal
to modify the population with a user-defined diffusion distribution
and a fast-fourier transformation (FFT) computational algorithm. It
is computationally efficient and very fast, however, only useful for
situations where dispersal barriers or arrival based on habitat or
carrying capacity are not required (e.g. a homogeneous landscape or
where diffusion alone is sufficient to explain dispersal patterns).
Dispersal is not constrained to suitable habitat or available carrying
capacity.
}
\examples{

# Example of fast kernel-based dispersal where all life stages disperse.
# The default dispersal kernel uses a decay parameter to control how far
# populations disperse. Note proportions of populations to disperse are
# controlled by approach to carrying capacity.

\dontrun{
fft_dispersal <- fast_dispersal(dispersal_proportion = density_dependence_dispersing(),
                     dispersal_kernel = exponential_dispersal_kernel(distance_decay = 1000))

ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat),
                          dispersal = fft_dispersal,
                          density_dependence = ceiling_density())

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
