% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_transition_functions-class.R
\name{competition_density}
\alias{competition_density}
\title{Competition density function}
\usage{
competition_density(
  stages = NULL,
  mask = NULL,
  R_max = NULL,
  stable_age = NULL
)
}
\arguments{
\item{stages}{which life-stages contribute to density dependence - default is all}

\item{mask}{a matrix of boolean values (TRUE/FALSE), equal in dimensions to the life-stage transition matrix
and specifying which vital rates (i.e. survival and fecundity) are to be modified by the function}

\item{R_max}{optional value of maximum growth rate (lambda) if known}

\item{stable_age}{optional vector of stable age distributions if known}
}
\description{
Adjusts the life-stage transition matrix in each cell based on the carrying capacity in the cell and
a density dependence function - default is Beverton-Holt. The user may specify which life-stages are 
affected by density dependence. If \code{R_max} is not provided this is calculated from the local cell-based
transition matrices internally. By providing initial stable age distribution values, performance can be
increased as the function internally calculates these values through optimisation.
}
\examples{

# Vital rates (survival and fecundity) modified based on approach to carrying capacity
# by the 2nd and 3rd life stages.

\dontrun{
mod_fun <- competition_density(stages = c(2, 3))

ls <- landscape(population = egk_pop, suitability = NULL, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat, transition_function = mod_fun))

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
