% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbnorm.R
\name{rbnorm}
\alias{rbnorm}
\title{Bounded Normal (Really: Scaled Beta) Distribution}
\usage{
rbnorm(n, mean, sd, lowerbound, upperbound, round = FALSE, seed)
}
\arguments{
\item{n}{the number of observations to simulate}

\item{mean}{a mean to approximate}

\item{sd}{a standard deviation to approximate}

\item{lowerbound}{a lower bound for the data to be generated}

\item{upperbound}{an upper bound for the data to be generated}

\item{round}{whether to round the values to whole integers. Defaults to FALSE}

\item{seed}{set an optional seed}
}
\value{
The function returns a vector of simulated data approximating the user-specified conditions.
}
\description{
\code{rbnorm()} is a function to randomly generate values from a bounded normal
(really: a scaled beta) distribution with specified mean, standard deviation, and upper/lower bounds.
I use this function to randomly generate data that we treat as interval for sake of getting
means and standard  deviations, but have discernible bounds (and even skew) to teach students
about things like random sampling and central limit theorem.
}
\details{
I call it "bounded normal" when it's really a beta distribution. I'm aware of this. I took
much of this code from somewhere. I forget where.
}
\examples{

library(tibble)

tibble(x = rbnorm(10000, 57, 14, 0, 100))
tibble(x = rbnorm(10000, 57, 14, 0, 100, round = TRUE))
tibble(x = rbnorm(10000, 57, 14, 0, 100, seed = 8675309))
}
