% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier.R
\name{outlier}
\alias{outlier}
\title{Image Outlier Detection}
\usage{
outlier(mat)
}
\arguments{
\item{mat}{data matrix. Each row is a row stacked image.}
}
\value{
a list containing the following entries:
\itemize{
  \item outidx: index of the outlier image
  \item outpct: percentage of outlier pixels corresponding to \code{outidx},
  \item outlst: a list of the same length as \code{outidx}, with each list the missing pixel index.
}
}
\description{
Image Outlier Detection
}
\examples{
dfB = landsat106[landsat106$year >= 2000,]
matB = as.matrix(dfB[,-c(1:2)])
outlier(matB)
}
