% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_rotor_grids.R
\name{get_y_grid}
\alias{get_y_grid}
\title{Grid of vertical distances from points in the rotor circle to its horizontal
axis}
\usage{
get_y_grid(x_grid, yinc = 0.05)
}
\arguments{
\item{x_grid}{A 2D array, with horizontal distances from the rotor's vertical axis,
expressed as the proportion of rotor radius, for the left-half of the
rotor circle area.}

\item{yinc}{a numeric value, the grid increment along the y-axis}
}
\value{
2D array giving a grid of vertical distances \eqn{y} from the rotor's
horizontal axis, expressed as the proportion of rotor radius, for
the left-half of the rotor circle area. Negative values represent distances
from the bottom half of the rotor circle.
}
\description{
Taking the center of the rotor circle as the origin,
\code{get_y_grid} generates a grid of vertical distances \eqn{y} (by
\code{yinc} increments) from the x-axis to the outer edge of the rotor
circle, across width intervals \eqn{x} (by \code{xinc} increments) between
the center and maximum rotor width.

Returned grid represents the left-half of the rotor's circle.

Distances are expressed as proportion of rotor radius (i.e. \eqn{y} is
dimensionless).
}
\examples{
 x_grid <- get_x_grid(yinc=0.05, xinc=0.05)
 get_y_grid(x_grid,yinc=0.05)

}
