df <- data.frame(entity_id = rep(1, 27),
                 timestamp = c(1, 2, 4, 10, 14, 18, 20, 21, 24, 25, 28, 29, 45, 80, 100,
                               120, 200, 270, 300, 340, 380, 450, 455, 460, 470, 475,
                               490),
                 longitude = c(5.1299311, 5.129979, 5.129597, 5.130028, 5.130555, 5.131083,
                               5.132101, 5.132704, 5.133326, 5.133904, 5.134746, 5.135613,
                               5.135613, 5.135613, 5.135613, 5.135613, 5.135613, 5.135613,
                               5.135613, 5.135613, 5.135613, 5.135613, 5.134746, 5.133904,
                               5.133326, 5.132704, 5.132101),
                 latitude = c(52.092839, 52.092827, 52.092571, 52.092292, 52.092076, 52.091821,
                              52.091420, 52.091219, 52.091343, 52.091651, 52.092138, 52.092698,
                              52.092698, 52.092698, 52.092698, 52.092698, 52.092698, 52.092698,
                              52.092698, 52.092698, 52.092698, 52.092138, 52.091651, 52.091343,
                              52.091219, 52.091420, 52.091821))
setDT(df)

testthat::test_that("stopFinder correctly clusters the stops and tracks", {
  testthat::expect_equal(stopFinder(copy(df), thetaD = 200, thetaT = 200)$state_id, c(rep(1, 11), rep(2, 13), rep(3, 3)))
  testthat::expect_equal(stopFinder(copy(df), thetaD = 200, thetaT = 200)$state, c(rep("moving", 11), rep("stopped", 13), rep("moving", 3)))
  testthat::expect_equal(stopFinder(copy(df), thetaD = 300, thetaT = 400)$state_id, c(rep(1, 9), rep(2, 18)))
})
