% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{points2odf}
\alias{points2odf}
\title{Convert a series of points into a dataframe of origins and destinations}
\usage{
points2odf(p)
}
\arguments{
\item{p}{A spatial points object}
}
\description{
Takes a series of geographical points and converts them into a data.frame
representing the potential flows, or 'spatial interaction', between every combination
of points.
}
\examples{
data(cents)
df <- points2odf(cents)
cents_centroids <- rgeos::gCentroid(cents, byid = TRUE)
df2 <- points2odf(cents_centroids)
df3 <- points2odf(cents_sf)
}
\seealso{
Other od: \code{\link{dist_google}}, \code{\link{od2line}},
  \code{\link{od2odf}}, \code{\link{od_aggregate}},
  \code{\link{od_coords2line}}, \code{\link{od_coords}},
  \code{\link{od_dist}}, \code{\link{od_radiation}},
  \code{\link{points2flow}}, \code{\link{sp_aggregate}}
}
\concept{od}
