% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simulate_temporal}
\alias{simulate_temporal}
\title{Simulates a temporal Hawkes process with an exponential correlation function}
\usage{
simulate_temporal(mu, alpha, beta, tt, times, seed = -1L)
}
\arguments{
\item{mu}{- background parameter}

\item{alpha}{- \eqn{\alpha} parameter}

\item{beta}{- \eqn{\beta} parameter}

\item{tt}{- vector of two elements defining time span (e.g., c(0,10))}

\item{times}{- history of previous times (e.g., numeric())}

\item{seed}{- value to seed random number generation (default = -1)}
}
\value{
arrivals - vector of arrival times
}
\description{
Simulates a temporal Hawkes process with an exponential correlation function
}
\examples{
    times = simulate_temporal(.5,.1,.5,c(0,10),numeric())
}
