% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/life.tab.R
\name{life.tab}
\alias{life.tab}
\title{Life table}
\usage{
life.tab(x, n = 1000)
}
\arguments{
\item{x}{A dataframe withtwo columns: Ages and number of deaths.}

\item{n}{Inicial number of individuals in the theoretical population.}
}
\value{
A dataframe with nine columns:
\item{age}{Age at the beginning of the interval.}
\item{Mx}{Number of observed deaths at age x.}
\item{Sx}{Number of survivors at age x in the observed cohort of sum(length(M)) individuals.}
\item{nx}{Number of survivors at age x in a theoretical cohort starting with n individuals.}
\item{dx}{Number of deaths at age x in a theoretical cohort starting with n individuals.}
\item{qx}{Probability of death between ages x and x + n.}
\item{lx}{Probability of survival to exact age x.}
\item{ex}{Life expectancy at age x.}
\item{Zx}{Instant death rate at age x}
}
\description{
Performs a regular life table from a dataframe with ages and number of death individuals.
}
\details{
Constructs a cohort life table from a dataframe with age classes and enumerated deaths.
}
\examples{

life.tab(cetaceans)

}
\references{
Preston, S.H., Heuveline, P. and Guillot, F. (2001). Demography: Measuring and modeling population processes. Oxford: Blackwell.
}
\keyword{life-table}
