% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heterozygosity.R
\name{heterozygosity}
\alias{heterozygosity}
\alias{exptdHet}
\alias{obsvdHet}
\title{Observed and Expected Heterozygosity}
\usage{
exptdHet(g)

obsvdHet(g)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}
}
\description{
Calculate observed heterozygosity for diploid data.
}
\note{
For a measure of haplotypic diversity (haploid "heterozygosity"), 
  use \code{exptdHet}. If \code{g} is a haploid object with sequences, make sure to run 
  \code{\link{labelHaplotypes}} if sequences aren't already grouped by 
  haplotype.
}
\examples{
data(msats.g)

# Expected heterozygosity
exptdHet(msats.g)

# Observed heterozygosity
obsvdHet(msats.g)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
