% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDgenepop.R
\name{LDgenepop}
\alias{LDgenepop}
\title{Linkage Disequlibrium}
\usage{
LDgenepop(
  g,
  dememorization = 10000,
  batches = 100,
  iterations = 5000,
  delete.files = TRUE,
  label = NULL
)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{dememorization, batches, iterations}{parameters for GENEPOP MCMC
LD procedure as defined in \code{\link[genepop]{test_LD}}.}

\item{delete.files}{logical. Delete GENEPOP input and output files when done?}

\item{label}{character string to use to label GENEPOP input and output files.}
}
\value{
data.frame of disequilibrium estimates between pairs of loci
}
\description{
Calculate linkage disequilibrium p-values using GENEPOP.
}
\examples{
\dontrun{
data(msats.g)
msats.ld <- LDgenepop(msats.g)
head(msats.ld)
}

}
\seealso{
\link{genepop}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
