% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popStructStat.R
\name{popStructStat}
\alias{popStructStat}
\alias{statChi2}
\alias{statJostD}
\alias{statFis}
\alias{statFst}
\alias{statFstPrime}
\alias{statGst}
\alias{statGstPrime}
\alias{statGstDblPrime}
\alias{statPhist}
\alias{Hstats}
\title{Population structure statistics}
\usage{
statChi2(g, nrep = NULL, keep.null = FALSE, ...)

statJostD(g, nrep = NULL, keep.null = FALSE, ...)

statFis(g, nrep = NULL, keep.null = FALSE, ...)

statFst(g, nrep = NULL, keep.null = FALSE, ...)

statFstPrime(g, nrep = NULL, keep.null = FALSE, ...)

statGst(g, nrep = NULL, keep.null = FALSE, ...)

statGstPrime(
  g,
  nrep = NULL,
  keep.null = FALSE,
  prime.type = c("hedrick", "nei"),
  ...
)

statGstDblPrime(g, nrep = NULL, keep.null = FALSE, ...)

statPhist(
  g,
  nrep = NULL,
  keep.null = FALSE,
  model = "K80",
  gamma = FALSE,
  pairwise.deletion = TRUE,
  ...
)

Hstats(g)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{nrep}{number specifying number of permutation replicates to use for 
permutation test.}

\item{keep.null}{logical. Keep the null distribution from the 
permutation test?}

\item{...}{optional arguments passed to or from other functions.}

\item{prime.type}{type of G'st to calculate. Can be "hedrick" or "nei".}

\item{model, gamma, pairwise.deletion}{parameters passed to 
\code{\link[ape]{dist.dna}}. Note that defaults for these arguments 
(in particular \code{model}) are the same as in \code{dist.dna}.}
}
\value{
A list with three elements: \describe{
  \item{stat.name}{the name of the statistic.}
  \item{result}{a vector of the statistic estimate and the p-value, 
    if replicates were conducted.}
  \item{null.dist}{a vector of the null distribution from the permutations.}
}
}
\description{
Population structure statistics
}
\note{
If \code{strata.mat} is provided, it must be a numeric matrix of 
  integers from \code{0} to \code{k - 1}, where \code{k} is the number of 
  strata. Each column is a separate permutation and the first column is 
  assumed to represent the original stratification. If not provided 
  (\code{strata.mat = NULL}), stratification is taken from \code{g}. 
  This argument is primarily used internally by \code{\link{popStructTest}}.
}
\references{
\describe{
  \item{Hstats, statFis}{Nei, M. and R.K. Chesser. 1983. Estimation of
    fixation indices and gene diversities. Ann. Hum. Genet. 47:253-259.}
  \item{statFst}{Weir, B. and Cockerham, C. 1984. Estimating F-Statistics 
    for the Analysis of Population Structure. Evolution 38(6):1358-1370. 
    doi:10.2307/2408641}
  \item{statGst, statGstPrime}{Nei, M. 1973. Analysis of gene diversity in 
    subdvidided populations. Proc. Nat. Acad. Sci. 70(12):3321-3323.  
    Hedrick, P.W. 2005. A standardized genetic differentiation measure. 
    Evolution 59(8):1633-1638.}
  \item{statFstPrime, statGstDblPrime}{Miermans, P.G. and P.W. Hedrick. 2011. 
    Assessing population structure: FST and related measures. Molecular 
    Ecology Resources 11:5-18.}
  \item{statJostD}{Jost, L. 2008. GST and its relatives do not measure 
    differentiation. Molecular Ecology 17:4015-4026.}
  \item{statPHIst}{Excoffier, L., P.E. Smouse, and J.M. Quattro. 1992. 
    Analysis of molecular variance inferred from metric distances among 
    DNA haplotypes: Application to human mitochondrial DNA restriction data. 
    Genetics 131:479-491.}
}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
