/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.lazy.neighboursearch;

import moa.classifiers.lazy.neighboursearch.DistanceFunction;
import weka.core.Instance;
import weka.core.Instances;

public abstract class NormalizableDistance
implements DistanceFunction {
    public static final int R_MIN = 0;
    public static final int R_MAX = 1;
    public static final int R_WIDTH = 2;
    protected Instances m_Data = null;
    protected boolean m_DontNormalize = false;
    protected double[][] m_Ranges;
    protected boolean[] m_ActiveIndices;
    protected boolean m_Validated;

    public NormalizableDistance() {
        this.invalidate();
    }

    public NormalizableDistance(Instances data) {
        this.setInstances(data);
    }

    public abstract String globalInfo();

    public String dontNormalizeTipText() {
        return "Whether if the normalization of attributes should be turned off for distance calculation (Default: false i.e. attribute values are normalized). ";
    }

    public void setDontNormalize(boolean dontNormalize) {
        this.m_DontNormalize = dontNormalize;
        this.invalidate();
    }

    public boolean getDontNormalize() {
        return this.m_DontNormalize;
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public void setAttributeIndices(String value) {
        this.invalidate();
    }

    public String getAttributeIndices() {
        return null;
    }

    public String invertSelectionTipText() {
        return "Set attribute selection mode. If false, only selected attributes in the range will be used in the distance calculation; if true, only non-selected attributes will be used for the calculation.";
    }

    public void setInvertSelection(boolean value) {
        this.invalidate();
    }

    public boolean getInvertSelection() {
        return false;
    }

    protected void invalidate() {
        this.m_Validated = false;
    }

    protected void validate() {
        if (!this.m_Validated) {
            this.initialize();
            this.m_Validated = true;
        }
    }

    protected void initialize() {
        this.initializeAttributeIndices();
        this.initializeRanges();
    }

    protected void initializeAttributeIndices() {
        this.m_ActiveIndices = new boolean[this.m_Data.numAttributes()];
        for (int i = 0; i < this.m_ActiveIndices.length; ++i) {
            this.m_ActiveIndices[i] = true;
        }
    }

    public void setInstances(Instances insts) {
        this.m_Data = insts;
        this.invalidate();
    }

    public Instances getInstances() {
        return this.m_Data;
    }

    public void postProcessDistances(double[] distances) {
    }

    public void update(Instance ins) {
        this.validate();
        this.m_Ranges = this.updateRanges(ins, this.m_Ranges);
    }

    public double distance(Instance first, Instance second) {
        return this.distance(first, second, Double.POSITIVE_INFINITY);
    }

    public double distance(Instance first, Instance second, double cutOffValue) {
        double distance = 0.0;
        int firstNumValues = first.numValues();
        int secondNumValues = second.numValues();
        int numAttributes = this.m_Data.numAttributes();
        int classIndex = this.m_Data.classIndex();
        this.validate();
        int p1 = 0;
        int p2 = 0;
        while (p1 < firstNumValues || p2 < secondNumValues) {
            double diff;
            int firstI = p1 >= firstNumValues ? numAttributes : first.index(p1);
            int secondI = p2 >= secondNumValues ? numAttributes : second.index(p2);
            if (firstI == classIndex) {
                ++p1;
                continue;
            }
            if (firstI < numAttributes && !this.m_ActiveIndices[firstI]) {
                ++p1;
                continue;
            }
            if (secondI == classIndex) {
                ++p2;
                continue;
            }
            if (secondI < numAttributes && !this.m_ActiveIndices[secondI]) {
                ++p2;
                continue;
            }
            if (firstI == secondI) {
                diff = this.difference(firstI, first.valueSparse(p1), second.valueSparse(p2));
                ++p1;
                ++p2;
            } else if (firstI > secondI) {
                diff = this.difference(secondI, 0.0, second.valueSparse(p2));
                ++p2;
            } else {
                diff = this.difference(firstI, first.valueSparse(p1), 0.0);
                ++p1;
            }
            if (!((distance = this.updateDistance(distance, diff)) > cutOffValue)) continue;
            return Double.POSITIVE_INFINITY;
        }
        return distance;
    }

    protected abstract double updateDistance(double var1, double var3);

    protected double norm(double x, int i) {
        if (Double.isNaN(this.m_Ranges[i][0]) || this.m_Ranges[i][1] == this.m_Ranges[i][0]) {
            return 0.0;
        }
        return (x - this.m_Ranges[i][0]) / this.m_Ranges[i][2];
    }

    protected double difference(int index, double val1, double val2) {
        switch (this.m_Data.attribute(index).type()) {
            case 1: {
                if (NormalizableDistance.isMissingValue(val1) || NormalizableDistance.isMissingValue(val2) || (int)val1 != (int)val2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (NormalizableDistance.isMissingValue(val1) || NormalizableDistance.isMissingValue(val2)) {
                    double diff;
                    if (NormalizableDistance.isMissingValue(val1) && NormalizableDistance.isMissingValue(val2)) {
                        if (!this.m_DontNormalize) {
                            return 1.0;
                        }
                        return this.m_Ranges[index][1] - this.m_Ranges[index][0];
                    }
                    if (NormalizableDistance.isMissingValue(val2)) {
                        diff = !this.m_DontNormalize ? this.norm(val1, index) : val1;
                    } else {
                        double d = diff = !this.m_DontNormalize ? this.norm(val2, index) : val2;
                    }
                    if (!this.m_DontNormalize && diff < 0.5) {
                        diff = 1.0 - diff;
                    } else if (this.m_DontNormalize) {
                        if (this.m_Ranges[index][1] - diff > diff - this.m_Ranges[index][0]) {
                            return this.m_Ranges[index][1] - diff;
                        }
                        return diff - this.m_Ranges[index][0];
                    }
                    return diff;
                }
                return !this.m_DontNormalize ? this.norm(val1, index) - this.norm(val2, index) : val1 - val2;
            }
        }
        return 0.0;
    }

    public double[][] initializeRanges() {
        if (this.m_Data == null) {
            this.m_Ranges = null;
            return this.m_Ranges;
        }
        int numAtt = this.m_Data.numAttributes();
        double[][] ranges = new double[numAtt][3];
        if (this.m_Data.numInstances() <= 0) {
            this.initializeRangesEmpty(numAtt, ranges);
            this.m_Ranges = ranges;
            return this.m_Ranges;
        }
        this.updateRangesFirst(this.m_Data.instance(0), numAtt, ranges);
        for (int i = 1; i < this.m_Data.numInstances(); ++i) {
            this.updateRanges(this.m_Data.instance(i), numAtt, ranges);
        }
        this.m_Ranges = ranges;
        return this.m_Ranges;
    }

    public void updateRangesFirst(Instance instance, int numAtt, double[][] ranges) {
        for (int j = 0; j < numAtt; ++j) {
            if (!instance.isMissing(j)) {
                ranges[j][0] = instance.value(j);
                ranges[j][1] = instance.value(j);
                ranges[j][2] = 0.0;
                continue;
            }
            ranges[j][0] = Double.POSITIVE_INFINITY;
            ranges[j][1] = Double.NEGATIVE_INFINITY;
            ranges[j][2] = Double.POSITIVE_INFINITY;
        }
    }

    public void updateRanges(Instance instance, int numAtt, double[][] ranges) {
        for (int j = 0; j < numAtt; ++j) {
            double value = instance.value(j);
            if (instance.isMissing(j)) continue;
            if (value < ranges[j][0]) {
                ranges[j][0] = value;
                ranges[j][2] = ranges[j][1] - ranges[j][0];
                if (!(value > ranges[j][1])) continue;
                ranges[j][1] = value;
                ranges[j][2] = ranges[j][1] - ranges[j][0];
                continue;
            }
            if (!(value > ranges[j][1])) continue;
            ranges[j][1] = value;
            ranges[j][2] = ranges[j][1] - ranges[j][0];
        }
    }

    public void initializeRangesEmpty(int numAtt, double[][] ranges) {
        for (int j = 0; j < numAtt; ++j) {
            ranges[j][0] = Double.POSITIVE_INFINITY;
            ranges[j][1] = Double.NEGATIVE_INFINITY;
            ranges[j][2] = Double.POSITIVE_INFINITY;
        }
    }

    public double[][] updateRanges(Instance instance, double[][] ranges) {
        for (int j = 0; j < ranges.length; ++j) {
            double value = instance.value(j);
            if (instance.isMissing(j)) continue;
            if (value < ranges[j][0]) {
                ranges[j][0] = value;
                ranges[j][2] = ranges[j][1] - ranges[j][0];
                continue;
            }
            if (!(instance.value(j) > ranges[j][1])) continue;
            ranges[j][1] = value;
            ranges[j][2] = ranges[j][1] - ranges[j][0];
        }
        return ranges;
    }

    public double[][] initializeRanges(int[] instList) throws Exception {
        if (this.m_Data == null) {
            throw new Exception("No instances supplied.");
        }
        int numAtt = this.m_Data.numAttributes();
        double[][] ranges = new double[numAtt][3];
        if (this.m_Data.numInstances() <= 0) {
            this.initializeRangesEmpty(numAtt, ranges);
            return ranges;
        }
        this.updateRangesFirst(this.m_Data.instance(instList[0]), numAtt, ranges);
        for (int i = 1; i < instList.length; ++i) {
            this.updateRanges(this.m_Data.instance(instList[i]), numAtt, ranges);
        }
        return ranges;
    }

    public double[][] initializeRanges(int[] instList, int startIdx, int endIdx) throws Exception {
        if (this.m_Data == null) {
            throw new Exception("No instances supplied.");
        }
        int numAtt = this.m_Data.numAttributes();
        double[][] ranges = new double[numAtt][3];
        if (this.m_Data.numInstances() <= 0) {
            this.initializeRangesEmpty(numAtt, ranges);
            return ranges;
        }
        this.updateRangesFirst(this.m_Data.instance(instList[startIdx]), numAtt, ranges);
        for (int i = startIdx + 1; i <= endIdx; ++i) {
            this.updateRanges(this.m_Data.instance(instList[i]), numAtt, ranges);
        }
        return ranges;
    }

    public void updateRanges(Instance instance) {
        this.validate();
        this.m_Ranges = this.updateRanges(instance, this.m_Ranges);
    }

    public boolean inRanges(Instance instance, double[][] ranges) {
        boolean isIn = true;
        for (int j = 0; isIn && j < ranges.length; ++j) {
            if (instance.isMissing(j)) continue;
            double value = instance.value(j);
            boolean bl = isIn = value <= ranges[j][1];
            if (!isIn) continue;
            isIn = value >= ranges[j][0];
        }
        return isIn;
    }

    public boolean rangesSet() {
        return this.m_Ranges != null;
    }

    public double[][] getRanges() throws Exception {
        this.validate();
        if (this.m_Ranges == null) {
            throw new Exception("Ranges not yet set.");
        }
        return this.m_Ranges;
    }

    public String toString() {
        return "";
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }
}

