% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream.R
\name{stream}
\alias{stream}
\title{Stream generator results into a document}
\usage{
stream(
  generator,
  context = active_document_context(),
  interface = c("prefix", "replace", "suffix")
)
}
\arguments{
\item{generator}{A \code{\link[coro:generator]{coro::generator()}} function.}

\item{context}{Optional. An RStudio document context.}

\item{interface}{One of \code{"prefix"}, \code{"replace"}, or \code{"suffix"}, describing
how to the active selection will be interfaced with. Defaults to \code{"replace"}.}
}
\value{
The streamed result, invisibly; called for its side effect, modifying the
context of the current selection with results from the generator.
}
\description{
Given an asychronous generator that produces text, this function iteratively
polls that generator and inlines its results into the currently open RStudio
or Positron document. This is particularly useful for streaming results
from large language models.
}
\details{
This function is generally not intended for interactive usage. See the
gander, pal, and ensure package, which this package powers.
}
\examples{
\dontrun{
if (rlang::is_installed("ellmer") &&
    !identical("ANTHROPIC_API_KEY", "") &&
    rstudioapi::isAvailable()
 ) {
  library(ellmer)

  gen <- chat_claude()$stream("hey there!")

  stream(gen, interface = "suffix")
}
}
}
