% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{sf_substr}
\alias{sf_substr}
\title{sf_substr}
\usage{
sf_substr(x, start, stop, nthreads = 1)
}
\arguments{
\item{x}{A character vector}

\item{start}{The begining to extract from}

\item{stop}{The end to extract from}

\item{nthreads}{Number of threads to use}
}
\value{
A stringfish vector of substrings
}
\description{
Extracts substrings from a character vector
}
\details{
This works the same way as `substr`, but in addition allows negative indexing. 
Negative indicies count backwards from the end of the string, with -1 being the last character.
}
\examples{
if(getRversion() >= "3.5.0") {
x <- c("fa\xE7ile", "hello world")
Encoding(x) <- "latin1"
x <- sf_iconv(x, "latin1", "UTF-8")
sf_substr(x, 4, -1) # extracts from the 4th character to the last
## [1] "ile"  "lo world"
}
}
\seealso{
substr
}
