% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_order}
\alias{stri_order}
\alias{stri_sort}
\title{Ordering Permutation and Sorting}
\usage{
stri_order(str, decreasing = FALSE, na_last = TRUE, opts_collator = NULL)

stri_sort(str, decreasing = FALSE, na_last = NA, opts_collator = NULL)
}
\arguments{
\item{str}{character vector}

\item{decreasing}{single logical value; should the sort order
be nondecreasing (\code{FALSE}, default)
or nonincreasing (\code{TRUE})?}

\item{na_last}{single logical value controlling the treatment of \code{NA}s
in \code{str}. If \code{TRUE}, then missing values in \code{str} are put
at the end; if \code{FALSE}, they are put first;
if \code{NA}, then they are removed from the output.}

\item{opts_collator}{a named list with \pkg{ICU} Collator's options
as generated with \code{\link{stri_opts_collator}}, \code{NULL}
for default collation options}
}
\value{
For \code{stri_order}, an integer vector that gives the sort order
is returned.

For \code{stri_order}, you get a sorted version of \code{str},
i.e. a character vector.
}
\description{
\link{stri_order} determines a permutation which rearranges
strings into ascending or descending order.
\link{stri_sort} sorts the vector according to a lexicographic order.
}
\details{
For more information on \pkg{ICU}'s Collator and how to tune it up
in \pkg{stringi}, refer to \code{\link{stri_opts_collator}}.

These functions use a stable sort algorithm (\pkg{STL}'s stable_sort),
which performs up to \eqn{N*log^2(N)} element comparisons,
where \eqn{N} is the length of \code{str}.

Interestingly, our benchmarks indicate that \code{stri_order}
is most often faster that \R's \code{order}.
}
\examples{
\donttest{
stri_sort(c("hladny", "chladny"), opts_collator=stri_opts_collator(locale="pl_PL"))

stri_sort(c("hladny", "chladny"), opts_collator=stri_opts_collator(locale="sk_SK"))
}
}
\seealso{
Other locale_sensitive: \code{\link{\%s!==\%}},
  \code{\link{\%s!=\%}}, \code{\link{\%s<=\%}},
  \code{\link{\%s<\%}}, \code{\link{\%s===\%}},
  \code{\link{\%s==\%}}, \code{\link{\%s>=\%}},
  \code{\link{\%s>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_boundaries}},
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search-coll}}
}

