% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pad-trim.r
\name{str_trunc}
\alias{str_trunc}
\title{Truncate a character string.}
\usage{
str_trunc(string, width, side = c("right", "left", "center"),
  ellipsis = "...")
}
\arguments{
\item{string}{A character vector.}

\item{width}{Maximum width of string.}

\item{side, ellipsis}{Location and content of ellipsis that indicates
content has been removed.}
}
\description{
Truncate a character string.
}
\examples{
x <- "This string is moderately long"
rbind(
  str_trunc(x, 20, "right"),
  str_trunc(x, 20, "left"),
  str_trunc(x, 20, "center")
)

}
\seealso{
\code{\link{str_pad}} to increase the minimum width of a string.
}
