% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold.R
\name{kfold}
\alias{kfold}
\title{k-Folds Crossvalidation}
\usage{
kfold(
  type,
  k = 5,
  max.invariance = "strict",
  seed = NULL,
  seeded.search = TRUE,
  ...,
  remove.details = TRUE
)
}
\arguments{
\item{type}{A \code{character} calling the item-selection procedure. Can be one of "mmas" (see \code{\link{mmas}}), "gene" (see \code{\link{gene}}), "bruteforce" (see \code{\link{bruteforce}}), or randomsamples (see \code{\link{randomsamples}}).}

\item{k}{The number of folds.}

\item{max.invariance}{The maximum measurement invariance level which will be tested. Currently there are four options: 'configural', 'weak', 'strong', and 'strict' (the default). All levels below \code{max.invariance} are also tested.}

\item{seed}{The random seed.}

\item{seeded.search}{A \code{logical} indicating whether the \code{seed} should also be used for the search procedure (the default) or only for the sample splitting.}

\item{...}{Arguments passed to the item-selection procedure called with \code{type}.}

\item{remove.details}{A \code{logical} indicating whether to remove detailed information such as models and copies of datasets. Reduces output size by approx. 90\%. Defaults to \code{TRUE}.}
}
\value{
Returns an object of the class \code{stuartKfold} for which specific \code{summary} and \code{print} methods are available. The results are a list.
\item{call }{The called function.}
\item{subtests}{A list containing the names of the selected items and their respective subtests.}
\item{solution}{A list of matrices with the choices made in the global-best solution.}
\item{final}{The results of the estimation of the solution leading to best objective value when cross-validated.}
\item{frequencies}{A list of matrices showing the relative frequencies with which an item was selected across the k-folds.}
\item{full}{A list of the results returned by the k runs of \code{type}.}
\item{crossvalidations}{A list of data.frames showing the fit and model comparisons of all invariance levels up to \code{max.invariance} in each of the k folds.}
\item{data}{A \code{data.frame}. The same as the original \code{data.frame} provided to \code{data} with the added variable \code{stuartKfold} indicating which fold an observation was assigned to.}
}
\description{
k-Folds crossvalidation for item selection using any approach implemented in STUART.
}
\details{
The function splits the provided data into k subsets using \code{\link{holdout}} and runs the item-selection procedure requested via \code{type} on the training datasets. Validation is performed using \code{\link{crossvalidate}} to check for invariance of the measurement models between the training and validation data up to the invariance level provided via \code{max.invariance}. The final item selection is based on the highest value on the objective function in the multiple-group SEM imposing \code{max.invariance} between the training and validation data.
}
\examples{

# k-Folding for a simple bruteforce selection
data(fairplayer)
fs <- list(ra = names(fairplayer)[53:57])

sel <- kfold('bruteforce', k = 2,
  data = fairplayer, factor.structure = fs, 
  capacity = 3, seed = 55635,
  cores = 1)
summary(sel)

\donttest{
### longitudinal example with mmas ----
data(fairplayer)
fs <- list(si1 = names(fairplayer)[83:92],
  si2 = names(fairplayer)[93:102],
  si3 = names(fairplayer)[103:112])

repe <- list(si = c('si1', 'si2', 'si3'))

sel_mmas <- kfold('mmas', k = 3,
  data = fairplayer, factor.structure = fs,
  repeated.measures = repe, long.invariance = 'strong',
  capacity = 3, seed = 55635, pbest = .5,
  cores = 1)
summary(sel_mmas)
}


}
\seealso{
\code{\link{holdout}} \code{\link{crossvalidate}}
}
\author{
Martin Schultze
}
