% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signals.R
\docType{data}
\name{signals}
\alias{CTRL_BREAK_EVENT}
\alias{CTRL_C_EVENT}
\alias{SIGABRT}
\alias{SIGALRM}
\alias{SIGCHLD}
\alias{SIGCONT}
\alias{SIGFPE}
\alias{SIGHUP}
\alias{SIGILL}
\alias{SIGINT}
\alias{SIGKILL}
\alias{SIGPIPE}
\alias{SIGQUIT}
\alias{SIGSEGV}
\alias{SIGSTOP}
\alias{SIGTERM}
\alias{SIGTSTP}
\alias{SIGTTIN}
\alias{SIGTTOU}
\alias{SIGUSR1}
\alias{SIGUSR2}
\alias{process_kill}
\alias{process_send_signal}
\alias{process_terminate}
\alias{signals}
\title{Sending signals to the child process.}
\format{An object of class \code{list}.}
\usage{
signals

process_terminate(handle)

process_kill(handle)

process_send_signal(handle, signal)

SIGABRT

SIGALRM

SIGCHLD

SIGCONT

SIGFPE

SIGHUP

SIGILL

SIGINT

SIGKILL

SIGPIPE

SIGQUIT

SIGSEGV

SIGSTOP

SIGTERM

SIGTSTP

SIGTTIN

SIGTTOU

SIGUSR1

SIGUSR2

CTRL_C_EVENT

CTRL_BREAK_EVENT
}
\arguments{
\item{handle}{Process handle obtained from \code{spawn_process()}.}

\item{signal}{Signal number, one of \code{names(signals)}.}
}
\description{
Sending signals to the child process.

Operating-System-level signals that can be sent via
\code{\link[subprocess]{process_send_signal}()} are defined in the
\code{subprocess::signals} list. It is a list that is generated when
the package is loaded and it contains only signals supported by the
current platform (Windows or Linux).

All signals, both supported and not supported by the current
platform, are also exported under their names. If a given signal
is not supported on the current platform, then its value is set to
\code{NA}.

Calling \code{process_kill()} and \code{process_terminate()} invokes
the appropriate OS routine (\code{waitpid()} or
\code{WaitForSingleObject()}, closing the process handle, etc.) that
effectively lets the operating system clean up after the child
process. Calling \code{process_send_signal()} is not accompanied by
such clean-up and if the child process exits it needs to be followed
by a call to \code{\link{process_wait}()}.

\code{process_terminate()} on Linux sends the
\code{SIGTERM} signal to the process pointed to by \code{handle}.
On Windows it calls \code{TerminateProcess()}.

\code{process_kill()} on Linux sends the \code{SIGKILL}
signal to \code{handle}. On Windows it is an alias for
\code{process_terminate()}.

\code{process_send_signal()} sends an OS-level
\code{signal} to \code{handle}. In Linux all standard signal
numbers are supported. On Windows supported signals are
\code{SIGTERM}, \code{CTRL_C_EVENT} and \code{CTRL_BREAK_EVENT}.
Those values will be available via the \code{signals} list which
is also attached in the package namespace.
}
\details{
In Windows, signals are delivered either only to the child process or
to the child process and all its descendants. This behavior is
controlled by the \code{termination_mode} argument of the
\code{\link[subprocess]{spawn_process}()} function. Setting it to
\code{TERMINATION_GROUP} results in signals being delivered to the
child and its descendants.
}
\examples{
\dontrun{
# send the SIGKILL signal to bash
h <- spawn_process('bash')
process_signal(h, signals$SIGKILL)
process_signal(h, SIGKILL)

# is SIGABRT supported on the current platform?
is.na(SIGABRT)
}

\dontrun{
# Windows
process_send_signal(h, SIGTERM)
process_send_signal(h, CTRL_C_EVENT)
process_send_signal(h, CTRL_BREAK_EVENT)
}

}
\seealso{
\code{\link{spawn_process}}
}
\keyword{datasets}

