% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clique.R
\name{CLIQUE}
\alias{CLIQUE}
\title{The CLIQUE Algorithm for Subspace Clustering}
\usage{
CLIQUE(data, xi = 10, tau = 0.2)
}
\arguments{
\item{data}{A Matrix of input data.}

\item{xi}{Number of Intervals.}

\item{tau}{Density Threshold.}
}
\description{
The CLIQUE Algorithm finds clusters by first dividing each
dimension into xi equal-width intervals and saving those intervals where the
density is greater than tau as clusters. Then each set of two dimensions is
examined: If there are two intersecting intervals in these two dimensions and
the density in the intersection of these intervals is greater than tau, the
intersection is again saved as a cluster. This is repeated for all sets of
three, four, five,\dots dimensions. After every step adjacent clusters are
replaced by a joint cluster and in the end all of the clusters are output.
}
\examples{
data("subspace_dataset")
CLIQUE(subspace_dataset,xi=40,tau=0.06)
}
\references{
Rakesh Agrawal, Johannes Gehrke, Dimitrios Gunopulos, and
 Prabhakar Raghavan. \emph{Automatic Subspace Clustering of High Dimensional
 Data for Data Mining Applications}. In Proc. ACM SIGMOD, 1999.
}
\seealso{
Other subspace.clustering.algorithms: \code{\link{FIRES}};
  \code{\link{P3C}}; \code{\link{ProClus}};
  \code{\link{SubClu}}
}

