% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_intervals.R
\name{count_intervals}
\alias{count_intervals}
\title{Count number of between-session intervals available to identify sudden gains}
\usage{
count_intervals(data, id_var_name, sg_var_list, identify_sg_1to2 = FALSE)
}
\arguments{
\item{data}{A data set in wide format including an ID variable and variables for each measurement point.}

\item{id_var_name}{String, specifying the name of the ID variable. Each row should have a unique value.}

\item{sg_var_list}{Vector, specifying the variable names of each measurement point sequentially.}

\item{identify_sg_1to2}{Logical, indicating whether to identify sudden losses from measurement point 1 to 2.
If set to TRUE, this implies that the first variable specified in \code{sg_var_list} represents a baseline measurement point, e.g. pre-intervention assessment.}
}
\value{
List with values for:
  \itemize{
    \item{total_between_sess_intervals}{: The total number of between-session intervals present in the data set, NAs are also included here. This multiplies the number of cases (rows) with the number of specified between-session intervals: \code{nrows * (length(sg_var_list) - 1)}.}
    \item{total_between_sess_intervals_sg}{: The total number of between-session intervals where sudden gains can theoretically, NAs are also included here. This multiplies the number of cases (rows) with the number of between-session intervals where sudden gains can be identified using the 3 original criteria: \code{nrows * (length(sg_var_list) - 3)}.}
    \item{available_between_sess_intervals_sg}{: The total number of between-session intervals that can be analysed for sudden gains taking into account the pattern of missing data.}
    \item{not_available_between_sess_intervals_sg}{: The total number of between-session intervals that can not be analysed for sudden gains due to the pattern of missing data.}
    }
}
\description{
Calculates the number of total between-session intervals present in the data set and the number of between-session intervals that are available to identify sudden gains talking into account the pattern of missing data.
}
\examples{
# Count between session intervals in "sgdata"
count_intervals(data = sgdata,
                id_var_name = "id",
                sg_var_list = c("bdi_s1", "bdi_s2", "bdi_s3", "bdi_s4",
                                "bdi_s5", "bdi_s6", "bdi_s7", "bdi_s8",
                                "bdi_s9", "bdi_s10", "bdi_s11", "bdi_s12"))
}
