% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_cases.R
\name{select_cases}
\alias{select_cases}
\title{Select sample providing enough data to identify sudden gains}
\usage{
select_cases(data, id_var_name, sg_var_list, method = c("pattern",
  "min_sess"), min_sess_num = NULL, return_id_lgl = FALSE)
}
\arguments{
\item{data}{A dataset in wide format with an id variable and the sudden gains variables.}

\item{id_var_name}{String, specifying the name of the ID variable. Each row should have a unique value.}

\item{sg_var_list}{Vector, specifying the variable names of each measurement point sequentially.}

\item{method}{String, specifying the method used to select cases: \code{pattern} or \code{min_sess}.}

\item{min_sess_num}{Numeric, minimum number of available sessions to be selected.
This argument needs to be specified if \code{method = min_sess}.}

\item{return_id_lgl}{Logical, if \code{TRUE} the function returns the ID variable and a new variable \code{sg_select} indicating whether there is enough data available to identify sudden gains.
If set to \code{FALSE} this function retruns the input data together with the new variable \code{sg_select}.}
}
\value{
A wide dataset indicating with all cases and a variable indicating whether each cases provides enough data to identify sudden gains.
}
\description{
Select sample for further sudden gains analyses depending on specified methods.

The following table shows the different data patterns that get selected when \code{method = "pattern"}.
This function goes through the data and selects all cases with at least one of the following data patterns.
\tabular{lrrrrrr}{
\strong{Pattern} \tab \strong{x1} \tab \strong{x2} \tab \strong{x3} \tab \strong{x4} \tab \strong{x5} \tab \strong{x6} \cr
\strong{1.}       \tab x           \tab \strong{N}  \tab x           \tab x           \tab .         \tab .           \cr
\strong{2.}       \tab x           \tab \strong{N}  \tab x           \tab .          \tab x          \tab .           \cr
\strong{3.}       \tab x           \tab .          \tab \strong{N}  \tab x           \tab x          \tab .           \cr
\strong{4.}       \tab x           \tab .          \tab \strong{N}  \tab x           \tab .          \tab x
}
\emph{Note}. x1 to x6 are consecutive data points of the primary outcome measure. 'x' = Available data; '.' = Missing data. '\strong{N}' represents available data to be examined as a possible pregain session.
}
\examples{
# 1. method = "pattern"
select_cases(data = sgdata,
             id_var_name = "id",
             sg_var_list = c("bdi_s1", "bdi_s2", "bdi_s3", "bdi_s4",
                             "bdi_s5", "bdi_s6", "bdi_s7", "bdi_s8",
                             "bdi_s9", "bdi_s10", "bdi_s11", "bdi_s12"),
             method = "pattern",
             return_id_lgl = FALSE)

# 2. method = "min_sess"
select_cases(data = sgdata,
             id_var_name = "id",
             sg_var_list = c("bdi_s1", "bdi_s2", "bdi_s3", "bdi_s4",
                             "bdi_s5", "bdi_s6", "bdi_s7", "bdi_s8",
                             "bdi_s9", "bdi_s10", "bdi_s11", "bdi_s12"),
             method = "min_sess",
             min_sess_num = 9,
             return_id_lgl = TRUE)
}
