% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holiday.R
\name{au_holiday}
\alias{au_holiday}
\title{Australia public holidays}
\usage{
au_holiday(year, state = "VIC")
}
\arguments{
\item{year}{A vector of integer(s) indicating year(s)}

\item{state}{A state in Australia. The abbreviation of the states in the upper
letter cases is required. Currently supports "VIC" (i.e. Victoria) only.}
}
\value{
A data frame consisting of \code{holiday} labels and their associated
dates in the year(s).
}
\description{
Australia public holidays
}
\details{
AFL public holidays are not reported for the Victoria state.
}
\examples{
au_holiday(2016, state = "VIC")
au_holiday(2013:2016, state = "VIC")

}
\references{
\href{http://www.business.vic.gov.au/victorian-public-holidays-and-daylight-saving/victorian-public-holidays}{Victoria public holidays}
}
