% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_stats.t.R
\name{summary_stats.t}
\alias{summary_stats.t}
\title{Calculate summary statistics on a data frame}
\usage{
summary_stats.t(data, measure, ...)
}
\arguments{
\item{data}{a data frame}

\item{measure}{a numeric variable. Response variable - summary statistics
will be returned for this variable}

\item{...}{a factor variable, or group of factor variables.  Data frame
will be grouped by this variable, and summary statistics will be produced
for each group}
}
\description{
Functions from dplyr are used to automate the process of
 calculating basic summary statistics on a data frame. Returned
 statistics include mean, standard deviation, standard error, count,
 and 95% confidence intervals. Functions are given for calculating
 confidence intervals from a normal distribution (summary_stats) and
 from a t-distribution (summary_stats.t)
}
\examples{
data(iris)
  summary_stats(iris, measure = "Sepal.Length")
  summary_stats(iris, measure = "Sepal.Length", Species)
}
