% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CousineauLaurencelleLambda.R
\name{CousineauLaurencelleLambda}
\alias{CousineauLaurencelleLambda}
\title{Cousineau-Laurencelle's lambda correction for cluster-randomized sampling}
\usage{
CousineauLaurencelleLambda(paramvector)
}
\arguments{
\item{paramvector}{A vector with, in that order, the intra-class correlation r,
the number of clusters, then the number of participants in all the clusters.}
}
\value{
lambda the correction factor for cluster-randomized sampling.
}
\description{
The functions CousineauLaurencelleLambda() returns the correction factor
for cluster-randomized sampling. This correction is then used
in a variety of ways, for example, to get the effective number of
participants (in a power study) or to correct a t-test.
See \insertCite{cl16}{superb}.
}
\examples{
# Example from Cousineau & Laurencelle, 2017, p. 124:
CousineauLaurencelleLambda( c(0.2, 5, 20, 20, 20, 20, 20) )
# 2.234188  

}
\references{
\insertAllCited{}
}
