##' @name air
##' @docType data
##' @title Environmental data timeseries
##' 
##' @format A \code{data.frame} with \eqn{111} observations (rows)
##' and \eqn{4} variables (columns).
##' 
##' @details Data was taken from an environmental study
##' that measured the four variables on 111 consecutive days.
##' \cr \cr
##' Columns are:
##' \describe{
##'  \item{ozone}{surface concentration of ozone in New York,
##'               in parts per million}
##'  \item{radiation}{solar radiation}
##'  \item{temperature}{observed temperature, in degrees Fahrenheit}
##'  \item{wind}{wind speed, in miles per hour}
##' }
##'
##' @seealso \code{\link{gamTerms}}
##'
##' @keywords datasets
##' 
##' @source Chambers J, Hastie T (eds). 1992.
##' \emph{Statistical Models in S}. pg 348.
##' Wadsworth and Brooks, Pacific Grove, CA.
##'
NULL
