% Generated by roxygen2 (4.0.1): do not edit by hand
\name{local}
\alias{locLR}
\alias{locLR.coxph}
\alias{locScore}
\alias{locScore.coxph}
\alias{locWald}
\alias{locWald.coxph}
\alias{local}
\title{Local tests for a model}
\usage{
locScore(x, ...)

\method{locScore}{coxph}(x, ..., all = FALSE, hypo = NULL,
  ties = c("breslow", "efron", "exact"))

locLR(x, ...)

\method{locLR}{coxph}(x, ..., all = FALSE, hypo = NULL,
  ties = c("breslow", "efron", "exact"))

locWald(x, ...)

\method{locWald}{coxph}(x, ..., all = FALSE, hypo = NULL)
}
\arguments{
\item{x}{A model of class \code{coxph}}

\item{...}{Additional arguments (not implemented)}

\item{all}{Fit \emph{all} combinations of predictors}

\item{hypo}{Hypothesis to test.
\cr
There should be at least one coefficient to exclude and one to keep.
\cr
This is a specified as vector of the same length as the number of
coefficients in the model.
\cr
This should be a logical vector
(i.e. composed of \code{TRUE} and \code{FALSE} or a vector of
\eqn{0}s and \eqn{1}s.
\itemize{
  \item \code{FALSE} or zeros indicate coefficients to exclude
  \item \code{TRUE} or ones indicate coefficients to keep.
}}

\item{ties}{Method of handling ties when refitting model.
\cr
Must be one of \code{breslow}, \code{efron} or \code{exact}.}
}
\value{
For \code{locScore} a \code{list} with the following elements,
which are \code{data.table}s:
\item{coef}{coefficients from refitted model(s)}
\item{score}{hypothesis and chi-square test}
For \code{locLR} and \code{locWald}, a \code{data.table}
showing the hypothesis being tested and the results of the test.
}
\description{
Local tests for a model
}
\details{
The null hypothesis is that some of the coefficients in
the model are zero (\eqn{H_0 :  \hat{B}_i=0, \quad i \geq 1}{H0: Bi=0})
vs. the alternative that at least one of them is nonzero.
\cr \cr
All of these tests are distributed as chi-square
with degrees of freedom \eqn{=} number of excluded coefficients.
\cr \cr
For the \bold{score} test,
the model is fitted again with the coefficients of
interest excluded.
\cr
A value for the remaining coefficients is obtained.
Then the complete model is fit again using these new values as
initial values for
those remaining coefficients and using zero as the initial
value for the excluded coefficients.
\cr
Values for the excluded coefficients are generated without
iteration. (I.e. the first values calculated, with no convergence towards
maximum likelihood estimators).
\cr
The test is:
\deqn{ \chi_{SC}^2 = U^T I^{-1} U}{
 SC = U I^-1 U}
where \eqn{U} is the score vector  and \eqn{I^{-1}}{I^-1} is the
covariance or inverse of the information matrix.
(These are given by \code{colSums(survival::coxph.detail(x)$score)}
and \code{x$var} respectively).
\cr \cr
For the \bold{likelihood ratio} test, the model is also refit with
the coefficients of interest excluded. The likelihood ratios
from the full model and those with coefficients excluded
are used to construct the test:
\deqn{ \chi^2_{LR} = 2(LR_{full} - LR_{excluded})}{
 LR = 2*( LR[full] - LR[excluded] )}
\cr \cr
The \bold{Wald} chi-squared statistic is given by:
\deqn{ \chi^2_W = \hat{B}^T I^{-1} \hat{B} }{
 W = B I^-1 B }
Where \eqn{\hat{B}}{B} is the vector of fitted coefficients
(from the complete model) thought to be \eqn{=0}.
\cr
\eqn{I^{-1}}{I^-1} is composed of the corresponding elements from the
covariance matrix of the model.
}
\examples{
data(larynx, package="KMsurv")
c1 <- coxph(Surv(time, delta) ~ factor(stage) + age, data=larynx)
locScore(c1, all=TRUE)
locScore(c1, hypo=c(0, 0, 0, 1))
locScore(coxph(Surv(time, delta) ~ stage + age, data=larynx))
###
data(larynx, package="KMsurv")
c1 <- coxph(Surv(time, delta) ~ factor(stage) + age, data=larynx, method="breslow")
locLR(c1, all=TRUE)
locLR(c1, hypo=c(FALSE, FALSE, FALSE, TRUE))
###
data(larynx, package="KMsurv")
c1 <- coxph(Surv(time, delta) ~ factor(stage) + age, data=larynx, method="breslow")
locWald(c1, all=TRUE)
locWald(c1, hypo=c(0, 0, 0, 1))
}
\references{
Examples are from:
\bold{K&M} Example 8.2, pp 264-6.
}
\keyword{htest}

