% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_km_pi.R
\name{calc_km_pi}
\alias{calc_km_pi}
\title{Generate Kaplan-Meier curves with prediction intervals from parametric bootstrap simulation}
\usage{
calc_km_pi(
  sim,
  trt = NULL,
  group = NULL,
  pi.range = 0.95,
  calc.obs = TRUE,
  simtimelast = NULL
)
}
\arguments{
\item{sim}{A `survparamsim` class object generated by \code{\link{surv_param_sim}} function.}

\item{trt}{An optional string to specify which column define treatment status.
You will have survival curves with different colors in \code{\link{plot_km_pi}} function.}

\item{group}{Optional string(s) to specify grouping variable(s).
You will have faceted survival curves for these variables in \code{\link{plot_km_pi}} function.}

\item{pi.range}{Prediction interval for simulated survival curves.}

\item{calc.obs}{A logical to specify whether KM estimates will be performed
for the observed data. Need be set as FALSE if survival information in the `newdata`` is dummy.}

\item{simtimelast}{An optional numeric to specify last simulation time for survival curve.
If NULL (default), the last observation time in the `newdata`` will be used.}
}
\description{
Generate Kaplan-Meier curves with prediction intervals from parametric bootstrap simulation
}
