% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_param_sim_pre_resampled.R
\name{surv_param_sim_pre_resampled}
\alias{surv_param_sim_pre_resampled}
\title{Simulation of parametric survival model with an already-resampled dataset}
\usage{
surv_param_sim_pre_resampled(
  object,
  newdata.resampled,
  newdata.orig = NULL,
  censor.dur = NULL,
  coef.var = TRUE,
  na.warning = TRUE
)
}
\arguments{
\item{object}{A \code{survreg} class object. Currently accept exponential,
lognormal, weibull, loglogistic, and gaussian distributions.}

\item{newdata.resampled}{A required input, the already resampled dataset for simulation.
This dataset must have: (a) \code{rep} variable indicating the #simulation groups, and (b) the same number of subjects per each \code{rep}}

\item{newdata.orig}{An optional input needed for calculating KM and HR for the observed data.}

\item{censor.dur}{A two elements vector specifying duration of events
censoring. Censoring time will be calculated with uniform distribution
between two numbers. No censoring will be applied if NULL is provided.}

\item{coef.var}{Boolean specifying whether parametric bootstrap are
performed on survival model coefficients, based on variance-covariance
matrix. If FALSE, prediction interval only reflects inherent variability
from survival events.}

\item{na.warning}{Boolean specifying whether warning will be shown if
\code{newdata} contain subjects with missing model variables.}
}
\value{
A \code{survparamsim} object that contains the original \code{survreg} class
object, newdata, and a data frame for predicted survival profiles.
}
\description{
Simulation of parametric survival model with an already-resampled dataset
}
\details{
See \code{\link[=surv_param_sim]{surv_param_sim()}} for additional details.
}
