% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_ensemble.R
\name{survensemble_train}
\alias{survensemble_train}
\title{Fits an ensemble of Cox-PH and Survival Random Forest (SRF)
with internal CV to tune SRF hyperparameters.}
\usage{
survensemble_train(
  df_train,
  predict.factors,
  fixed_time = NaN,
  inner_cv = 3,
  randomseed = NULL,
  srf_tuning = list(),
  fast_version = TRUE,
  oob = TRUE,
  useCoxLasso = FALSE,
  var_importance_calc = 1
)
}
\arguments{
\item{df_train}{data, "time" and "event"  describe survival outcome}

\item{predict.factors}{list of the column names to be used as predictors}

\item{fixed_time}{for which the performance is maximized}

\item{inner_cv}{number of inner cycles for model tuning}

\item{randomseed}{random seed}

\item{srf_tuning}{list of mtry, nodedepth and nodesize, to use default supply empty list()}

\item{fast_version}{TRUE/FALSE, TRUE by default}

\item{oob}{FALSE/TRUE, TRUE by default}

\item{useCoxLasso}{FALSE/TRUE, FALSE by default}

\item{var_importance_calc}{FALSE/TRUE, TRUE by default}
}
\value{
trained object of class survensemble
}
\description{
Details: the function trains Cox model, then adds its out-of-the-box
predictions to Survival Random Forest as an additional predictor
to mimic stacking procedure used in Machine Learning and reduce over-fitting.
#' Cox model is fitted to .9 data to predict the rest .1 for each 1/10s fold;
these out-of-the-bag predictions are passed on to SRF
}
