\name{survivalBIV-package}
\alias{survivalBIV-package}
\alias{survivalBIV}
\docType{package}
\title{Estimation of the Bivariate Distribution Function}
\description{The \pkg{survivalBIV} software contains functions that compute estimates for the bivariate distribution function. This package can be used to implement four methods. One of these estimators is the conditional Kaplan-Meier estimator, based on Bayes' theorem and Kaplan-Meier estimator (CKM); also, two recent estimators based on the Kaplan-Meier weights pertaining to the distribution of the total time (KMW and KMPW). It also implements the inverse probability of censoring weighted estimator (IPCW). }

%\details{
%\tabular{ll}{
%Package: \tab survivalBIV\cr
%Type: \tab Package\cr
%Version: \tab 1.0\cr
%Date: \tab 2011-01-18\cr
%License: \tab What license is it under?\cr
%LazyLoad: \tab yes\cr
%}
%~~ An overview of how to use the package, including the most important functions ~~
%}

\author{Ana Moreira, Artur Agostinho Araujo \email{b5498@math.uminho.pt} and Luis Meira Machado \email{lmachado@math.uminho.pt}

Maintainer: Ana Moreira \email{id2809@alunos.uminho.pt}
}

\references{
%~~ Literature or other references for background information ~~
de Una-Alvarez J, Amorim AP (2011). "A Semiparametric Estimator of the Bivariate Distribution Function for Censored Gap Times", \emph{Biometrical Journal}, \bold{53}, 113-127.

de Una-Alvarez J, Meira Machado LF (2008). "A Simple Estimator of the Bivariate Distribution Function for Censored Gap Times", \emph{Statistical and Probability Letters}, \bold{78}, 2440-2445.

Gerds, TA, Schumacher, M (2006). "Consistent estimation of the expected bries score in general survival models with right-censored event times", \emph{Biometrical Journal}, \bold{48}, 1029-1040.

Lin D, Sun W, Ying Z (1999). "Nonparametric Estimation of the Time Distributions for Serial Events with Censored Data", \emph{Biometrika}, \bold{86}, 59-70.

Meira Machado LF, Moreira A (2010). "Estimation of the Bivariate Distribution Function for Censored Gap Times". \emph{Proceedings of the 19th International Conference on Computational Statistics, pp. 1367-1374}.

Davison, A.C. and Hinkley, D.V. (1997) "Bootstrap Methods and Their Application", Chapter 5. Cambridge University Press.

Johnson N, Kotz S (1972). "Distribution in statistics: continuous multivariate distribution", John Wiley and Sons.

Lu J, Bhattacharya G (1990). "Some new constructions of bivariate weibull models", Annals of Institute of Statistical Mathematics, \bold{42}, 543-559.
}

%~~ Optionally other standard keywords, one per line, from file KEYWORDS in the R documentation directory ~~

%\keyword{package}

%\seealso{
%~~ Optional links to other man pages, e.g. ~~
%~~ \code{\link[<pkg>:<pkg>-package]{<pkg>}} ~~
%}

%\examples{
%~~ simple examples of the most important functions ~~
%}
