% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KMWdf.R
\name{KMWdf}
\alias{KMWdf}
\title{Kaplan-Meier Weighted estimator for the bivariate distribution 
function.}
\usage{
KMWdf(object, x, y)
}
\arguments{
\item{object}{An object of class multidf.}

\item{x}{The first time for obtaining estimates for the bivariate 
distribution function.}

\item{y}{The second time for obtaining estimates for the bivariate distribution
function.}
}
\value{
Vector with the Kaplan-Meier weights estimates for the bivariate 
distribution function.
}
\description{
Provides estimates for the bivariate distribution 
function
based on Kaplan-Meier Weights (KMW).
}
\examples{
data("bladder4state")

b3state<-multidf(gap1=bladder4state$y1, event1=bladder4state$d1, 
                 gap2=bladder4state$y2, status=bladder4state$d2, 
                 size=bladder4state$size)
                 
KMWdf(b3state, x=13, y=20)

}
\references{
de Una-Alvarez J, Meira Machado LF (2008). "A Simple Estimator of
the Bivariate Distribution Function for Censored Gap Times", Statistical and
Probability Letters, 78, 2440-2445.

Davison, A.C. and Hinkley, D.V. (1997) "Bootstrap Methods and Their Application",
Chapter 5.
Cambridge University Press.
}
\seealso{
\code{\link{IPCWdf}}, \code{\link{LDMdf}}, \code{\link{LINdf}} and 
\code{\link{WCHdf}}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
