% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LINdf.R
\name{LINdf}
\alias{LINdf}
\title{Lin's estimator for the bivariate distribution function.}
\usage{
LINdf(object, x, y)
}
\arguments{
\item{object}{An object of class multidf.}

\item{x}{The first time for obtaining estimates for the bivariate distribution
function.}

\item{y}{The second time for obtaining estimates for the bivariate 
distribution function.}
}
\value{
Vector with the Lin's estimates for the bivariate distribution 
function.
}
\description{
Provides estimates for the bivariate distribution function based
on the extension the Kaplan-Meier estimator of the distribution function for
the first event time and the Inverse Probability of Censoring Weights for the
second time.
}
\examples{

b3state<-multidf(gap1=bladder4state$y1, event1=bladder4state$d1, 
                 gap2=bladder4state$y2, status=bladder4state$d2, 
                 size=bladder4state$size)
             
LINdf(b3,x=13,y=20)

}
\references{
Lin, D. Y., Sun, W. and Ying, Z. (1999). Nonparametric estimation 
of the gap time distributions for serial events with censored data, 
Biometrika 86, 59-70.
}
\seealso{
\code{\link{IPCWdf}}, \code{\link{LDMdf}}, \code{\link{KMWdf}} and
\code{\link{WCHdf}}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado
}
