% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{centers_ca}
\alias{centers_ca}
\title{Compute Coordinates for Cluster Centers}
\usage{
centers_ca(x, clusters, freq)
}
\arguments{
\item{x}{A numeric matrix.}

\item{clusters}{A clustering of the row levels of \code{x}: either a list or the output of \code{kmeans}.}

\item{freq}{An optional vector of frequency counts for the row levels of \code{x}.}
}
\value{
A matrix containing the coordinates of the cluster centers.
}
\description{
A helper function for computing the coordinates of cluster centers (typically used in correspondence analysis).
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
sca.SndT_Fra <- fast_sca(SndT_Fra)
kcl.SndT_Fra <- kmeans(sca.SndT_Fra$pos1, centers = 7)
centers_ca(sca.SndT_Fra$pos1, clusters = kcl.SndT_Fra, freq = freq_ca(SndT_Fra[, 1]))
}
\seealso{
\code{\link{freq_ca}}.
}
