% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{log_or_0}
\alias{log_or_0}
\title{Logarithmic transform}
\usage{
log_or_0(x, base = exp(1))
}
\arguments{
\item{x}{A table or a (sparse) matrix.}

\item{base}{Numeric specification of the base with respect to which logarithms are computed.}
}
\value{
An array with the logarithm of every entry and 0 for all zero entries.
}
\description{
A function for computing the logarithm of every entry in a table with 0 for zero entries.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
tab.SndT_Fra <- table(SndT_Fra)
log_or_0(tab.SndT_Fra)
}
